/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.ISegment;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class IntegerSegment
implements ISegment<Integer>,
Comparable<IntegerSegment> {
    @SerId(value=1)
    int address;
    @SerId(value=2)
    int size;

    public IntegerSegment(int n, int n2) {
        this.address = n;
        this.size = n2;
    }

    @Override
    public int compareTo(IntegerSegment integerSegment) {
        return Integer.compare(this.address, integerSegment.address);
    }

    @Override
    public Integer getBegin() {
        return this.address;
    }

    @Override
    public Integer getEnd() {
        return this.address + this.size;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return String.format("%d-%d", this.getBegin(), this.getEnd());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.address;
        n2 = 31 * n2 + this.size;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IntegerSegment integerSegment = (IntegerSegment)object;
        if (this.address != integerSegment.address) {
            return false;
        }
        return this.size == integerSegment.size;
    }
}

