/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.collect;

import com.pnfsoftware.jeb.util.collect.IExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static boolean containsNull(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNonNull(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (obj == null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsReference(Collection<? extends T> collection, T t) {
        if (collection == null) {
            return false;
        }
        for (T t2 : collection) {
            if (t2 != t) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Collection<?> collection, Object object) {
        return collection != null && collection.contains(object);
    }

    @Deprecated
    public static <T> List<T> intersection(List<? extends T> list, List<? extends T> list2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : list) {
            if (!list2.contains(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> Set<T> intersect(Collection<? extends T> collection, Collection<? extends T> collection2) {
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : collection) {
            if (!collection2.contains(t)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T, K extends Comparable<K>> T binarySearch(List<T> list, K k2, IExtractor<T, K> iExtractor) {
        int n = CollectionUtil.binarySearchEx(list, k2, iExtractor, null);
        return n < 0 ? null : (T)list.get(n);
    }

    public static <T, K extends Comparable<K>> int binarySearchEx(List<? extends T> list, K k2, IExtractor<T, ? extends K> iExtractor, Comparator<K> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3;
            int n4 = n + n2 >>> 1;
            Comparable comparable = (Comparable)iExtractor.extract(list.get(n4));
            int n5 = n3 = comparator != null ? comparator.compare(comparable, k2) : comparable.compareTo(k2);
            if (n3 < 0) {
                n = n4 + 1;
                continue;
            }
            if (n3 > 0) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n + 1);
    }

    public static <T> boolean compareByReference(Collection<? extends T> collection, Collection<? extends T> collection2, boolean bl2) {
        if (collection == null && collection2 == null) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        if (bl2) {
            Iterator<T> iterator = collection.iterator();
            Iterator<T> iterator2 = collection2.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == iterator2.next()) continue;
                return false;
            }
        } else {
            IdentityHashMap identityHashMap = new IdentityHashMap();
            for (T t : collection) {
                identityHashMap.put(t, null);
            }
            for (T t : collection2) {
                if (identityHashMap.containsKey(t)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> boolean compare(Collection<? extends T> collection, Collection<? extends T> collection2, boolean bl2) {
        if (collection == null && collection2 == null) {
            return true;
        }
        if (collection == null || collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        if (bl2) {
            Iterator<T> iterator = collection.iterator();
            Iterator<T> iterator2 = collection2.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                T t2 = iterator2.next();
                if (t == null && t2 == null || !(t == null && t2 != null || t != null && t2 == null) && (t == null || t.equals(t2))) continue;
                return false;
            }
        } else {
            ArrayList<T> arrayList = new ArrayList<T>(collection2);
            for (T t : collection) {
                int n = 0;
                for (Object e2 : arrayList) {
                    if (t == null && e2 == null || t != null && t.equals(e2)) break;
                    ++n;
                }
                if (n >= arrayList.size()) {
                    return false;
                }
                arrayList.remove(n);
            }
        }
        return true;
    }
}

