/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.base;

import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IniFileEditor {
    File file;
    List<String> lines;

    public IniFileEditor(File file) throws IOException {
        this.file = file;
        this.load();
    }

    private void load() throws IOException {
        this.lines = IO.readLines(new FileInputStream(this.file), Charset.defaultCharset());
    }

    public void update() throws IOException {
        this.write(this.file);
    }

    public void write(File file) throws IOException {
        IO.writeLines(new FileOutputStream(file), this.lines, Charset.defaultCharset());
    }

    public List<String> getSectionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int j = 0; j < this.lines.size(); ++j) {
            String string = this.lines.get(j).trim();
            if (!string.startsWith("[") || !string.endsWith("]")) continue;
            arrayList.add(string.substring(1, string.length() - 1));
        }
        return arrayList;
    }

    public List<String> getSectionContents(String string) {
        int[] nArray = this.getSection(string, false);
        if (nArray == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.lines.subList(nArray[0], nArray[1])) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void setSectionContents(String string, List<String> list) {
        int[] nArray = this.getSection(string, true);
        int n = nArray[0];
        int n2 = nArray[1];
        if (n < this.lines.size()) {
            int n3 = n2 - n;
            while (n3-- > 0) {
                this.lines.remove(n);
            }
        }
        for (String string2 : list) {
            if ((string2 = string2.trim()).isEmpty()) continue;
            this.lines.add(n, string2);
            ++n;
        }
        this.lines.add(n, "");
    }

    private int[] getSection(String string, boolean bl2) {
        String string2;
        int n;
        String string3 = "[" + string + "]";
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.lines.size(); ++n) {
            string2 = this.lines.get(n).trim();
            if (!string2.equals(string3)) continue;
            n2 = n + 1;
            break;
        }
        if (n2 < 0) {
            if (!bl2) {
                return null;
            }
            this.lines.add(string3);
            n2 = this.lines.size();
        }
        for (n = n2; n < this.lines.size(); ++n) {
            string2 = this.lines.get(n).trim();
            if (!string2.startsWith("[")) continue;
            n3 = n;
            break;
        }
        if (n3 < 0) {
            n3 = this.lines.size();
        }
        return new int[]{n2, n3};
    }

    public String getValue(String string, String string2) {
        return this.getValue(string, string2, "=");
    }

    public String getValue(String string, String string2, String string3) {
        for (String string4 : this.getSectionContents(string)) {
            String string5;
            int n = string4.indexOf(string3);
            if (n < 0 || !(string5 = string4.substring(0, n).trim()).equals(string2)) continue;
            return string4.substring(n + string3.length()).trim();
        }
        return null;
    }

    public boolean setValue(String string, String string2, String string3) {
        return this.setValue(string, string2, string3, "=");
    }

    public boolean setValue(String string, String string2, String string3, String string4) {
        int n;
        List<String> list = this.getSectionContents(string);
        for (n = 0; n < list.size(); ++n) {
            String string5;
            String string6 = list.get(n);
            int n2 = string6.indexOf(string4);
            if (n2 < 0 || !(string5 = string6.substring(0, n2).trim()).equals(string2)) continue;
            String string7 = string6.substring(n2 + string4.length()).trim();
            if (string7.equals(string3)) {
                return false;
            }
            list.set(n, string2 + string4 + string3);
            break;
        }
        if (n >= list.size()) {
            list.add(string2 + string4 + string3);
        }
        this.setSectionContents(string, list);
        return true;
    }
}

