/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.xml;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.xml.pX;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.util.Map;

public class XmlIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(XmlIdentifier.class);
    public static final String TYPE = "xml";

    public XmlIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("XML reader", "XML reader with re-formatting/beautifying", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        String[] stringArray = new String[]{".html", ".htm", ".svg"};
        if (iInput instanceof FileInput && Strings.endsWith(((FileInput)iInput).getFile().getName().toLowerCase(), stringArray)) {
            return false;
        }
        if (string != null && Strings.endsWith(string.toLowerCase(), stringArray)) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return XmlIdentifier.isXMLHeader(byArray, 0);
    }

    static boolean isXMLHeader(byte[] byArray, int n) {
        while (n <= byArray.length - 5) {
            byte by2 = byArray[n];
            if (XmlIdentifier.isXMLWhiteSpace(by2)) {
                ++n;
                continue;
            }
            return by2 == 60 && byArray[n + 1] == 63 && (byArray[n + 2] | 0x20) == 120 && (byArray[n + 3] | 0x20) == 109 && (byArray[n + 4] | 0x20) == 108;
        }
        return false;
    }

    static boolean isXMLWhiteSpace(int n) {
        return n == 32 || n == 9 || n == 13 || n == 10;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        pX pX2 = new pX(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return pX2;
    }
}

