/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.jar;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.jar.OI;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class JarIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(JarIdentifier.class);
    public static final String TYPE = "jar";
    static final String manifestName = "META-INF/MANIFEST.MF";

    public JarIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("JAR parser", "JAR archive handler", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        if (!JarIdentifier.checkBytes(iInput, 0, 80, 75, 3, 4)) {
            return false;
        }
        try (ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(iInput.getStream(), "UTF8", true, true);){
            ZipArchiveEntry zipArchiveEntry;
            do {
                if ((zipArchiveEntry = zipArchiveInputStream.getNextZipEntry()) != null) continue;
                boolean bl2 = false;
                return bl2;
            } while (!zipArchiveEntry.getName().equals(manifestName));
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        OI oI = new OI(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return oI;
    }
}

