/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@Ser
public class LC {
    @SerId(value=1)
    int eO;
    @SerId(value=2)
    int Le;
    @SerId(value=3)
    int Qx;
    @SerId(value=4)
    byte[] lS;
    @SerId(value=5)
    byte[] ae;
    @SerId(value=6)
    String TI = "";
    @SerId(value=7)
    String vT;

    public static LC eO(ByteBuffer byteBuffer, boolean bl2) {
        byte[] byArray;
        int n;
        LC lC2 = new LC();
        int n2 = 4;
        lC2.eO = byteBuffer.getInt();
        lC2.Le = byteBuffer.getInt();
        lC2.Qx = byteBuffer.getInt();
        if (bl2 && (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN && lC2.Le == 0 || byteBuffer.order() == ByteOrder.BIG_ENDIAN && lC2.eO == 0)) {
            byteBuffer.position(byteBuffer.position() - 12);
            n2 = 8;
            lC2.eO = (int)byteBuffer.getLong();
            lC2.Le = (int)byteBuffer.getLong();
            lC2.Qx = (int)byteBuffer.getLong();
        }
        if (lC2.eO != 0) {
            n = (lC2.eO + n2 - 1) / n2 * n2;
            byArray = new byte[n];
            byteBuffer.get(byArray);
            lC2.lS = Arrays.copyOf(byArray, lC2.eO - 1);
            try {
                lC2.TI = new String(lC2.lS, "US-ASCII");
            }
            catch (Exception exception) {
                lC2.TI = "";
            }
        }
        if (lC2.Le != 0) {
            n = (lC2.Le + n2 - 1) / n2 * n2;
            byArray = new byte[n];
            byteBuffer.get(byArray);
            lC2.ae = Arrays.copyOf(byArray, lC2.Le);
        } else {
            lC2.ae = new byte[0];
        }
        if (lC2.TI.equals("GNU")) {
            if (lC2.Qx == 3) {
                lC2.vT = "Build ID[sha1]=" + Formatter.byteArrayToHexString(lC2.ae);
            } else if (lC2.Qx == 1) {
                lC2.vT = ELF.getNoteGnuABIString(lC2.ae, byteBuffer.order());
            }
        } else if (lC2.TI.equals("Android")) {
            lC2.vT = ELF.getNoteAndroidVersionString(lC2.ae, byteBuffer.order());
        }
        return lC2;
    }

    public String toString() {
        return String.format("Owner: %s%n    - type: %s%n    - description: %s\n", this.TI, ELF.getNoteTypeString(this.TI, this.Qx), this.vT != null ? this.vT : Formatter.escapeBytes(this.ae));
    }
}

