/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.dex.odex;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.SubInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.nio.ByteBuffer;

@Ser
public class OI
extends AbstractBinaryUnit {
    @SerId(value=1)
    private int eO;
    @SerId(value=2)
    private int Le;
    @SerId(value=3)
    private int Qx;
    @SerId(value=4)
    private int lS;
    @SerId(value=5)
    private int ae;
    @SerId(value=6)
    private int TI;
    @SerId(value=7)
    private int vT;
    @SerId(value=8)
    private int KQ;

    protected OI(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "odex", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    protected boolean processInternal() {
        try {
            ByteBuffer byteBuffer = this.getInput().getHeader();
            if (byteBuffer.remaining() <= 40) {
                return false;
            }
            this.eO = byteBuffer.getInt(8);
            this.Le = byteBuffer.getInt(12);
            this.Qx = byteBuffer.getInt(16);
            this.lS = byteBuffer.getInt(20);
            this.ae = byteBuffer.getInt(24);
            this.TI = byteBuffer.getInt(28);
            this.vT = byteBuffer.getInt(32);
            this.KQ = byteBuffer.getInt(36);
            if ((this.eO & 0xFFFF0000) != 0) {
                this.eO = Integer.reverseBytes(this.eO);
                this.Le = Integer.reverseBytes(this.Le);
                this.Qx = Integer.reverseBytes(this.Qx);
                this.lS = Integer.reverseBytes(this.lS);
                this.ae = Integer.reverseBytes(this.ae);
                this.TI = Integer.reverseBytes(this.TI);
                this.vT = Integer.reverseBytes(this.vT);
                this.KQ = Integer.reverseBytes(this.KQ);
            }
            SubInput subInput = new SubInput(this.getInput(), this.eO, this.Le);
            IUnit iUnit = this.getUnitProcessor().process("inner_dex", subInput, this, "dex");
            this.addChildUnit(iUnit);
        }
        catch (IOException iOException) {
            this.logError(false, "An error occurred while processing the ODEX file", new Object[0]);
            JebCoreService.notifySilentExceptionToClient(iOException);
            return false;
        }
        return true;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        stringBuilder.append("\n");
        stringBuilder.append("ODEX header:\n");
        stringBuilder.append(String.format("- Optimized DEX: offset= %Xh, size= %Xh\n", this.eO, this.Le));
        stringBuilder.append(String.format("- Dependency table: offset= %Xh, size= %Xh\n", this.Qx, this.lS));
        stringBuilder.append(String.format("- Optimized data tables: offset= %Xh, size= %Xh\n", this.ae, this.TI));
        return stringBuilder.toString();
    }
}

