/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.INativeDisassemblerPlugin;
import com.pnfsoftware.jebglobal.Yo;
import com.pnfsoftware.jebglobal.pI;

public class NativeCodePseudoIdentifier
extends AbstractUnitIdentifier {
    private INativeDisassemblerPlugin<?> nativeCodePlugin;

    public NativeCodePseudoIdentifier(INativeDisassemblerPlugin<?> iNativeDisassemblerPlugin) {
        super(iNativeDisassemblerPlugin.getFormatType(), iNativeDisassemblerPlugin.getPriority());
        this.nativeCodePlugin = iNativeDisassemblerPlugin;
    }

    public INativeDisassemblerPlugin<?> getPlugin() {
        return this.nativeCodePlugin;
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return this.nativeCodePlugin.getPluginInformation();
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition("WantedEndianness", PropertyTypeString.create("le"), "Desired endianness for raw binaries: 'little'/'le', 'big'/'be'. May be overridden by the code parser.");
        this.pdm.addDefinition("WantedImageBase", PropertyTypeString.create("0"), "Desired memory base address for raw binaries. 0 by default.");
        this.pdm.addInternalDefinition("PreferHexAddresses", PropertyTypeBoolean.create(true));
        this.pdm.addDefinition("AllowAdvancedAnalysis", PropertyTypeBoolean.create(!Licensing.isDebugBuild()), "The advanced analysis is an optional analysis pass that comes after the initial standard analysis. It permits discovery of indirect dispatch, therefore providing better routine discovery coverage, and partial resolution of register values.");
        this.pdm.addDefinition("AdvancedAnalysisRoutineCountWarning", PropertyTypeInteger.createPositiveOrZero(200), "If the standard analysis yields more routines that this provided threshold, then the user will be prompted for confirmation before starting the optional advanced analysis pass (and subsequent passes).");
        this.pdm.addDefinition("PerformClassRecovery", PropertyTypeBoolean.create(false), "Attempt C++ class discovery and rebuilding (limited to MSVC-compiled x86 executables for now)");
        this.pdm.addDefinition("PerformGlobalAnalysis", PropertyTypeBoolean.create(!Licensing.isDebugBuild()), "Global analysis passes are optional passes provided by specific decompiler modules. They may allow recovery of complex artifacts, such as classes or modules.");
        this.pdm.addDefinition("PreferSynchronousExecution", PropertyTypeBoolean.create(false), "Synchronous analysis prevents access to the unit during a code analysis");
        this.pdm.addDefinition("AnalysisStyle", PropertyTypeInteger.create(0, 4, 1), "Native analysis style:\n0 = forced conservative analysis\n1 = automatic mode (depends on the file)\n2 = forced aggressive analysis\n3 = forced lazy analysis\n4 = forced lazy no data analysis");
        int n = Licensing.isDebugBuild() ? 1 : 2;
        this.pdm.addDefinition("DebugInformationUsagePolicy", PropertyTypeInteger.create(0, 2, n), "Apply and use debug information to improve analysis accuracy (on a best-effort basis):\n0 = never use debug information\n1 = use internal debug information only\n2 = use all available (internal and external) debug information");
        this.pdm.addDefinition("DebugInformationRetrievalPolicy", PropertyTypeInteger.create(0, 2, 2), "Policy regarding the retrieval of externally-stored debugging and symbolic information of code objects:\n0 = never attempt\n1 = retrieve locally stored external symbols\n2 = attempt to retrieve locally and network-stored symbols\nLocations are architecture- and code object- dependent and may be customized via environment variables. Refer to the manual for additional documentation.");
        pI.eO(this.pdm);
        this.nativeCodePlugin.setupCustomProperties(this.pdm);
    }

    @Override
    public boolean acceptAnyInputBytes() {
        return this.nativeCodePlugin.canBeProcessedOutsideCodeObject();
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator) {
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator) {
        Yo yo = new Yo(string, this.getFormatType(), iInput, iUnitProcessor, iUnitCreator, this.pdm);
        yo.setMemory(this.nativeCodePlugin.getMemory(iUnitCreator));
        yo.setProcessor(this.nativeCodePlugin.getProcessor(iUnitCreator));
        yo.setCodeFormatter(this.nativeCodePlugin.getCodeFormatter());
        yo.setAnalyzerExtension(this.nativeCodePlugin.getAnalyzerExtension());
        return yo;
    }
}

