/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypePath;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.apk.pX;
import com.pnfsoftware.jeb.util.encoding.zip.fsr.ZipFailSafeReader;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ApkIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(ApkIdentifier.class);
    public static final String TYPE = "apk";
    public static final String propnameFrameworksDirectory = "FrameworksDirectory";
    public static final String propnameMergeMultiDex = "MergeMultiDex";
    public static final String propnameGenerateAapt2Output = "GenerateAapt2Output";
    public static final String propnameProcessManifest = "ProcessManifest";
    public static final String propnameProcessResources = "ProcessResources";
    public static final String propnameProcessCertificates = "ProcessCertificates";
    public static final String propnameProcessBytecode = "ProcessBytecode";
    public static final String propnameProcessLibraries = "ProcessLibraries";
    public static final String propnameProcessAssets = "ProcessAssets";
    public static final String propnameProcessOther = "ProcessOther";
    public static final String propnameAndroidJavadocRoot = "AndroidJavadocRoot";
    public static final String propnameDisableResourcesProcessingThreshold = "DisableResourcesProcessingThreshold";
    public static final String propnameDisableAssetsProcessingThreshold = "DisableAssetsProcessingThreshold";
    static final String manifestName = "AndroidManifest.xml";
    static final String resourcesName = "resources.arsc";
    static final String dexClassesName = "classes.dex";
    static final String jarClassesName = "classes.jar";
    private static final String KEY_APKFILE = "apkfile";

    public ApkIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("APK parser", "Android APK application handler", "PNF Software", Version.create(1, 1, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameFrameworksDirectory, PropertyTypePath.create(), "Directory containing additional frameworks. Leave empty to use the default, which is the '.jeb-android-frameworks' directory in your Home folder");
        this.pdm.addDefinition(propnameMergeMultiDex, PropertyTypeBoolean.create(true), "Attempt to merge the DEX files of a multi-DEX APK into a single, unified DEX unit");
        this.pdm.addDefinition(propnameGenerateAapt2Output, PropertyTypeBoolean.create(false), "Tick to generate an additional text fragment that will describe the APK resources similarly to AAPT2's output");
        this.pdm.addDefinition(propnameProcessManifest, PropertyTypeBoolean.create(true), "Decode and process the APK Manifest");
        this.pdm.addDefinition(propnameProcessResources, PropertyTypeBoolean.create(true), "Decode and process the Resources (if this option is true, the Manifest is always processed)");
        this.pdm.addDefinition(propnameProcessBytecode, PropertyTypeBoolean.create(true), "Process the Dalvik bytecode (classes[N].dex)");
        this.pdm.addDefinition(propnameProcessCertificates, PropertyTypeBoolean.create(true), "Process the APK's certificates data (legacy, v1, and v2)");
        this.pdm.addDefinition(propnameProcessLibraries, PropertyTypeBoolean.create(true), "Process native code (.so) libraries");
        this.pdm.addDefinition(propnameProcessAssets, PropertyTypeBoolean.create(true), "Process files in the APK's Assets directory");
        String string = "($ANDROID_HOME/docs|$ANDROID_SDK_HOME/docs|$ANDROID_SDK_ROOT/docs)/reference/;https://developer.android.com/reference/;($JAVA_HOME)/docs/api";
        this.pdm.addDefinition(propnameAndroidJavadocRoot, PropertyTypeString.create(string), "Location of Java/Android API documentation files; by default, local files stored in your Android SDK folder will be preferred over web-based API doc");
        this.pdm.addDefinition(propnameDisableResourcesProcessingThreshold, PropertyTypeInteger.createPositiveOrZero(500), "The plugin will suggest disabling the auto-processing of APK resources if the number of resource files exceed that threshold (0 to disable)", 2);
        this.pdm.addDefinition(propnameDisableAssetsProcessingThreshold, PropertyTypeInteger.createPositiveOrZero(300), "The plugin will suggest disabling the auto-processing of APK assets if the number of asset files exceed that threshold (0 to disable)", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (!ApkIdentifier.checkBytes(iInput, 0, 80, 75, 3, 4)) {
            return false;
        }
        File file = null;
        boolean bl2 = false;
        try {
            block55: {
                Object object;
                Object object2;
                block52: {
                    boolean bl3;
                    block53: {
                        block54: {
                            block49: {
                                boolean bl4;
                                block50: {
                                    block51: {
                                        if (iInput instanceof FileInput) {
                                            file = ((FileInput)iInput).getFile();
                                        } else {
                                            try {
                                                object2 = iInput.getStream();
                                                Throwable throwable = null;
                                                try {
                                                    object = IO.readInputStream((InputStream)object2);
                                                    file = File.createTempFile("jebTempFile", null, null);
                                                    bl2 = true;
                                                    IO.writeFile(file, (byte[])object, false);
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable = throwable2;
                                                    throw throwable2;
                                                }
                                                finally {
                                                    if (object2 != null) {
                                                        if (throwable != null) {
                                                            try {
                                                                ((InputStream)object2).close();
                                                            }
                                                            catch (Throwable throwable3) {
                                                                throwable.addSuppressed(throwable3);
                                                            }
                                                        } else {
                                                            ((InputStream)object2).close();
                                                        }
                                                    }
                                                }
                                            }
                                            catch (IOException iOException) {
                                                logger.catching(iOException);
                                                boolean bl5 = false;
                                                if (file != null && bl2) {
                                                    file.delete();
                                                }
                                                return bl5;
                                            }
                                        }
                                        object = new ZipFailSafeReader(file);
                                        object2 = null;
                                        if (((ZipFailSafeReader)object).hasEntry(manifestName) || ((ZipFailSafeReader)object).hasEntry(dexClassesName) || ((ZipFailSafeReader)object).hasEntry(resourcesName)) break block49;
                                        bl4 = false;
                                        if (object == null) break block50;
                                        if (object2 == null) break block51;
                                        try {
                                            ((ZipFailSafeReader)object).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object2).addSuppressed(throwable);
                                        }
                                        break block50;
                                    }
                                    ((ZipFailSafeReader)object).close();
                                }
                                return bl4;
                            }
                            if (((ZipFailSafeReader)object).hasEntry(dexClassesName) || !((ZipFailSafeReader)object).hasEntry(jarClassesName)) break block52;
                            bl3 = false;
                            if (object == null) break block53;
                            if (object2 == null) break block54;
                            try {
                                ((ZipFailSafeReader)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                            break block53;
                        }
                        ((ZipFailSafeReader)object).close();
                    }
                    return bl3;
                }
                try {
                    if (object != null) {
                        if (object2 != null) {
                            try {
                                ((ZipFailSafeReader)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            ((ZipFailSafeReader)object).close();
                        }
                    }
                    break block55;
                    catch (Throwable throwable) {
                        try {
                            object2 = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable4) {
                            if (object != null) {
                                if (object2 != null) {
                                    try {
                                        ((ZipFailSafeReader)object).close();
                                    }
                                    catch (Throwable throwable5) {
                                        ((Throwable)object2).addSuppressed(throwable5);
                                    }
                                } else {
                                    ((ZipFailSafeReader)object).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                }
                catch (IOException iOException) {
                    logger.catching(iOException);
                    boolean bl6 = false;
                    return bl6;
                }
            }
            if (map != null && bl2) {
                map.put(KEY_APKFILE, file);
                bl2 = false;
            }
            boolean bl7 = true;
            return bl7;
        }
        finally {
            if (file != null && bl2) {
                file.delete();
            }
        }
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        pX pX2 = new pX(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        if (map != null && map.containsKey(KEY_APKFILE)) {
            pX2.eO = (File)map.get(KEY_APKFILE);
            pX2.Le = true;
        }
        return pX2;
    }
}

