/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IDataProvider;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.LazyInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.UnknownBinaryUnit;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@Ser
public class LazyDataContainerUnit
extends ContainerUnit {
    private static final ILogger logger = GlobalLog.getLogger(LazyDataContainerUnit.class);
    @SerId(value=1)
    private Entry root;

    public LazyDataContainerUnit(Entry entry, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(entry.name, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
        this.root = entry;
    }

    @Override
    public boolean process(boolean bl2) {
        if (this.isProcessed()) {
            return true;
        }
        LazyDataContainerUnit.register(this, this.root.children.values());
        this.setProcessed(true);
        return true;
    }

    public static void register(IUnit iUnit, Collection<Entry> collection) {
        for (Entry entry : collection) {
            AbstractUnit abstractUnit;
            if (entry.isFolder()) {
                abstractUnit = new LazyDataContainerUnit(entry, iUnit.getUnitProcessor(), (IUnitCreator)iUnit, iUnit.getPropertyDefinitionManager());
                abstractUnit.process();
            } else {
                LazyInput lazyInput = new LazyInput(entry.prv, entry.entryName, entry.entrySize, entry.index);
                abstractUnit = new UnknownBinaryUnit(entry.name, (IInput)lazyInput, iUnit.getUnitProcessor(), (IUnitCreator)iUnit, iUnit.getPropertyDefinitionManager());
            }
            iUnit.addChild(abstractUnit);
        }
    }

    @Ser
    public static class Entry {
        @SerId(value=1)
        private IDataProvider prv;
        @SerId(value=2)
        private String entryName;
        @SerId(value=3)
        private long entrySize;
        @SerId(value=4)
        private String name;
        @SerId(value=5)
        private Map<String, Entry> children = new LinkedHashMap<String, Entry>();
        @SerId(value=6)
        private byte[] data;
        @SerId(value=7)
        private int index = 0;

        public static Entry create(IDataProvider iDataProvider, String string, long l2, String string2, int n) {
            return new Entry(iDataProvider, string, l2, string2, n);
        }

        public static Entry createFolder(String string) {
            return new Entry(null, null, 0L, string, 0);
        }

        private Entry(IDataProvider iDataProvider, String string, long l2, String string2, int n) {
            this.prv = iDataProvider;
            this.entryName = string;
            this.entrySize = l2;
            this.name = string2;
            this.index = n;
        }

        public boolean isFolder() {
            return this.entryName == null;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public Map<String, Entry> getChildren() {
            return this.children;
        }
    }
}

