/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;

@Ser
@SerVersion(value=2)
public class SymbolInformation
implements ISymbolInformation {
    @SerId(value=1)
    SymbolType type;
    @SerId(value=2)
    int flags;
    @SerId(value=3)
    long identifier;
    @SerId(value=4)
    String name;
    @SerId(value=5)
    long address;
    @SerId(value=6)
    long symbolAddress;
    @SerId(value=7)
    long symbolSize;
    @SerId(value=8, version=1)
    int procMode;
    @SerId(value=9, version=2)
    String dataTypeInfo;

    public SymbolInformation(SymbolType symbolType, int n, long l2, String string, long l3, long l4, long l5) {
        this.type = symbolType;
        this.flags = n;
        this.identifier = l2;
        this.name = string;
        this.address = l3;
        this.symbolAddress = l4;
        this.symbolSize = l5;
    }

    @Override
    public SymbolType getType() {
        return this.type;
    }

    public void setType(SymbolType symbolType) {
        this.type = symbolType;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(long l2) {
        this.identifier = l2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public long getRelativeAddress() {
        return this.address;
    }

    public void setRelativeAddress(long l2) {
        this.address = l2;
    }

    @Override
    public long getSymbolRelativeAddress() {
        return this.symbolAddress;
    }

    public void setSymbolRelativeAddress(long l2) {
        this.symbolAddress = l2;
    }

    @Override
    public long getSymbolSize() {
        return this.symbolSize;
    }

    public void setSymbolSize(long l2) {
        this.symbolSize = l2;
    }

    @Override
    public String getSymbolDataTypeInformation() {
        return this.dataTypeInfo;
    }

    public void setSymbolDataTypeInformation(String string) {
        this.dataTypeInfo = string;
    }

    @Override
    public int getProcessorMode() {
        return this.procMode;
    }

    public void setProcessorMode(int n) {
        this.procMode = n;
    }

    public boolean isInternal() {
        return (this.flags & 2) == 0 && (this.flags & 1) == 0;
    }

    public String toString() {
        return String.format("%s|%X|id=%X|\"%s\"|a=%X|symb@%X,s=%X|dti=%s|pm=%d", new Object[]{this.getType(), this.getFlags(), this.getIdentifier(), this.getName(), this.getRelativeAddress(), this.getSymbolRelativeAddress(), this.getSymbolSize(), this.getSymbolDataTypeInformation(), this.getProcessorMode()});
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (int)(this.address ^ this.address >>> 32);
        n2 = 31 * n2 + this.flags;
        n2 = 31 * n2 + (int)(this.identifier ^ this.identifier >>> 32);
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (int)(this.symbolAddress ^ this.symbolAddress >>> 32);
        n2 = 31 * n2 + (int)(this.symbolSize ^ this.symbolSize >>> 32);
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        n2 = 31 * n2 + (this.dataTypeInfo == null ? 0 : this.dataTypeInfo.hashCode());
        n2 = 31 * n2 + this.procMode;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SymbolInformation symbolInformation = (SymbolInformation)object;
        if (this.address != symbolInformation.address) {
            return false;
        }
        if (this.flags != symbolInformation.flags) {
            return false;
        }
        if (this.identifier != symbolInformation.identifier) {
            return false;
        }
        if (this.name == null ? symbolInformation.name != null : !this.name.equals(symbolInformation.name)) {
            return false;
        }
        if (this.symbolAddress != symbolInformation.symbolAddress) {
            return false;
        }
        if (this.symbolSize != symbolInformation.symbolSize) {
            return false;
        }
        if (this.type != symbolInformation.type) {
            return false;
        }
        if (this.dataTypeInfo == null ? symbolInformation.dataTypeInfo != null : !this.dataTypeInfo.equals(symbolInformation.dataTypeInfo)) {
            return false;
        }
        return this.procMode == symbolInformation.procMode;
    }
}

