/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.code.wincommon.Winunp;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;

@Ser
public class CoffDebugDirectoryEntry {
    public static final int SIZE_ON_DISK = 28;
    @SerId(value=1)
    int Characteristics;
    @SerId(value=2)
    int TimeDateStamp;
    @SerId(value=3)
    int MajorVersion;
    @SerId(value=4)
    int MinorVersion;
    @SerId(value=5)
    int Type;
    @SerId(value=6)
    int SizeOfData;
    @SerId(value=7)
    int AddressOfRawData;
    @SerId(value=8)
    int PointerToRawData;

    public static CoffDebugDirectoryEntry parse(ByteBuffer byteBuffer) {
        CoffDebugDirectoryEntry coffDebugDirectoryEntry = new CoffDebugDirectoryEntry();
        coffDebugDirectoryEntry.Characteristics = byteBuffer.getInt();
        coffDebugDirectoryEntry.TimeDateStamp = byteBuffer.getInt();
        coffDebugDirectoryEntry.MajorVersion = Winunp.getUINT16(byteBuffer);
        coffDebugDirectoryEntry.MinorVersion = Winunp.getUINT16(byteBuffer);
        coffDebugDirectoryEntry.Type = byteBuffer.getInt();
        coffDebugDirectoryEntry.SizeOfData = byteBuffer.getInt();
        coffDebugDirectoryEntry.AddressOfRawData = byteBuffer.getInt();
        coffDebugDirectoryEntry.PointerToRawData = byteBuffer.getInt();
        return coffDebugDirectoryEntry;
    }

    private CoffDebugDirectoryEntry() {
    }

    public int getCharacteristics() {
        return this.Characteristics;
    }

    public int getTimeDateStamp() {
        return this.TimeDateStamp;
    }

    public int getMajorVersion() {
        return this.MajorVersion;
    }

    public int getMinorVersion() {
        return this.MinorVersion;
    }

    public int getType() {
        return this.Type;
    }

    public int getSizeOfData() {
        return this.SizeOfData;
    }

    public int getAddressOfRawData() {
        return this.AddressOfRawData;
    }

    public int getPointerToRawData() {
        return this.PointerToRawData;
    }
}

