/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.type;

import com.pnfsoftware.jeb.core.units.code.asm.type.CodeConstant;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Ser
public class CodeConstantManager {
    public static final CodeConstantManager EMPTY = new CodeConstantManager(1);
    @SerId(value=1)
    int status;
    @SerId(value=2)
    Map<String, Set<Object>> mapnames = new HashMap<String, Set<Object>>();
    @SerId(value=3)
    Map<Object, Set<String>> mapvalues = new HashMap<Object, Set<String>>();

    public CodeConstantManager() {
        this(0);
    }

    private CodeConstantManager(int n) {
        this.status = n;
    }

    public boolean isLocked() {
        return (this.status & 1) != 0;
    }

    private void verifyNotLocked() {
        if (this.isLocked()) {
            throw new IllegalStateException("The manager is in read-only mode");
        }
    }

    public boolean isLegalName(String string) {
        return string != null && string.length() > 0;
    }

    public boolean isLegalValue(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof String;
    }

    public List<CodeConstant> getNamedConstantsByValue(Object object) {
        ArrayList<CodeConstant> arrayList = new ArrayList<CodeConstant>();
        for (String string : this.getNamesByValue(object)) {
            arrayList.add(new CodeConstant(string, object));
        }
        return arrayList;
    }

    public Set<String> getNamesByValue(Object object) {
        if (!this.isLegalValue(object)) {
            throw new IllegalArgumentException();
        }
        Set<String> set = this.mapvalues.get(object);
        return set != null ? set : Collections.emptySet();
    }

    public Set<Object> getValuesByName(String string) {
        if (!this.isLegalName(string)) {
            throw new IllegalArgumentException();
        }
        Set<Object> set = this.mapnames.get(string);
        return set != null ? set : Collections.emptySet();
    }

    public void clear() {
        this.verifyNotLocked();
        this.mapnames.clear();
        this.mapvalues.clear();
    }

    public int size() {
        int n = 0;
        for (Set<Object> set : this.mapnames.values()) {
            n += set.size();
        }
        return n;
    }

    public void addConstant(String string, Object object) {
        this.verifyNotLocked();
        if (!this.isLegalName(string) || !this.isLegalValue(object)) {
            throw new IllegalArgumentException();
        }
        Set<Object> set = this.mapnames.get(string);
        if (set == null) {
            set = new HashSet<Object>();
            this.mapnames.put(string.intern(), set);
        }
        set.add(object);
        Set<String> set2 = this.mapvalues.get(object);
        if (set2 == null) {
            set2 = new HashSet<String>();
            this.mapvalues.put(object, set2);
        }
        set2.add(string.intern());
    }

    public void removeConstant(String string, Object object) {
        Set<String> set;
        this.verifyNotLocked();
        if (!this.isLegalName(string) || !this.isLegalValue(object)) {
            throw new IllegalArgumentException();
        }
        Set<Object> set2 = this.mapnames.get(string);
        if (set2 != null) {
            set2.remove(object);
            if (set2.isEmpty()) {
                this.mapnames.remove(string);
            }
        }
        if ((set = this.mapvalues.get(object)) != null) {
            set.remove(string);
            if (set.isEmpty()) {
                this.mapvalues.remove(object);
            }
        }
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.mapnames == null ? 0 : this.mapnames.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CodeConstantManager codeConstantManager = (CodeConstantManager)object;
        return !(this.mapnames == null ? codeConstantManager.mapnames != null : !this.mapnames.equals(codeConstantManager.mapnames));
    }

    public String toString() {
        return this.mapnames.toString();
    }
}

