/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.simulator;

import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.simulator.IInsnEmulator;

public abstract class InsnEmulator<T extends IInstructionOperand>
implements IInsnEmulator<T> {
    public static final int NO_FLAG = 0;
    public static final int UPDATE_MASK = 255;
    public static final int UPDATE_NONE = 0;
    public static final int UPDATE_PC = 1;
    public static final int JUMP_MASK = 65280;
    public static final int JUMP_LAST_OPERAND = 256;
    public static final int LINK = 65536;
    private int flags;

    public InsnEmulator(int n) {
        this.flags = n;
    }

    @Override
    public boolean isPCUpdated() {
        switch (this.getFlags() & 0xFF) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IInsnEmulator.BranchType getBranchType() {
        if ((this.getFlags() & 0xFF) == 0) {
            return null;
        }
        if ((this.getFlags() & 0x10000) != 0) {
            return IInsnEmulator.BranchType.CALL;
        }
        return IInsnEmulator.BranchType.JMP;
    }

    public int getFlags() {
        return this.flags;
    }
}

