/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.sig;

import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ICompiler;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.LibraryID;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class NativeSignaturePackageMetadata {
    @SerId(value=1)
    ProcessorType targetProcessorType;
    @SerId(value=2)
    String name;
    @SerId(value=3)
    int version;
    @SerId(value=4)
    String description;
    @SerId(value=5)
    String author;
    @SerId(value=6)
    long creationTimestamp;
    @SerId(value=7)
    ICompiler targetCompiler;
    @SerId(value=8)
    LibraryID libraryId;
    @SerId(value=9)
    int uuid;

    public static NativeSignaturePackageMetadata create(ProcessorType processorType, String string, int n, int n2, String string2, String string3, ICompiler iCompiler, LibraryID libraryID) {
        NativeSignaturePackageMetadata nativeSignaturePackageMetadata = new NativeSignaturePackageMetadata(processorType, string);
        nativeSignaturePackageMetadata.version = n2;
        nativeSignaturePackageMetadata.description = string2;
        nativeSignaturePackageMetadata.author = string3;
        nativeSignaturePackageMetadata.creationTimestamp = System.currentTimeMillis() / 1000L;
        nativeSignaturePackageMetadata.targetCompiler = iCompiler;
        nativeSignaturePackageMetadata.libraryId = libraryID;
        nativeSignaturePackageMetadata.uuid = n;
        return nativeSignaturePackageMetadata;
    }

    private NativeSignaturePackageMetadata(ProcessorType processorType, String string) {
        if (processorType == null || string == null) {
            throw new NullPointerException();
        }
        this.targetProcessorType = processorType;
        this.name = string;
    }

    public ProcessorType getTargetProcessorType() {
        return this.targetProcessorType;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public ICompiler getTargetCompiler() {
        return this.targetCompiler;
    }

    public String toString() {
        return String.format("%s/%s/%d/%s/%s/%d", new Object[]{this.targetProcessorType, this.name, this.version, this.description, this.author, this.creationTimestamp});
    }

    public LibraryID getLibraryId() {
        return this.libraryId;
    }

    public int getUuid() {
        return this.uuid;
    }
}

