/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.memory;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryAllocListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryFreeListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryPropertyListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryProtectionListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IMemoryWriteListener;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;

@Ser
public abstract class AbstractVirtualMemory
implements IVirtualMemory {
    @SerTransient
    private byte[] data = new byte[8];

    @SerCustomInit
    private void init() {
        this.data = new byte[8];
    }

    @Override
    public long roundToPage(long l2) {
        int n = this.getPageSize();
        return l2 / (long)n * (long)n;
    }

    @Override
    public long roundToSize(long l2) {
        int n = this.getPageSize();
        return (l2 + (long)n - 1L) / (long)n * (long)n;
    }

    @Override
    public void allocatePage(long l2, int n) throws MemoryException {
        this.allocate(l2, 1, n);
    }

    @Override
    public void freePage(long l2) throws MemoryException {
        this.free(l2, 1);
    }

    @Override
    public synchronized byte readByte(long l2) throws MemoryException {
        this.read(l2, 1, this.data, 0);
        return this.data[0];
    }

    @Override
    public synchronized void writeByte(long l2, byte by2) throws MemoryException {
        this.data[0] = by2;
        this.write(l2, 1, this.data, 0);
    }

    @Override
    public synchronized short readLEShort(long l2) throws MemoryException {
        this.read(l2, 2, this.data, 0);
        return ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    @Override
    public synchronized void writeLEShort(long l2, short s2) throws MemoryException {
        ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).putShort(s2);
        this.write(l2, 2, this.data, 0);
    }

    @Override
    public synchronized int readLEInt(long l2) throws MemoryException {
        this.read(l2, 4, this.data, 0);
        return ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    @Override
    public synchronized void writeLEInt(long l2, int n) throws MemoryException {
        ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).putInt(n);
        this.write(l2, 4, this.data, 0);
    }

    @Override
    public synchronized long readLELong(long l2) throws MemoryException {
        this.read(l2, 8, this.data, 0);
        return ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    @Override
    public synchronized void writeLELong(long l2, long l3) throws MemoryException {
        ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN).putLong(l3);
        this.write(l2, 8, this.data, 0);
    }

    @Override
    public synchronized short readBEShort(long l2) throws MemoryException {
        this.read(l2, 2, this.data, 0);
        return ByteBuffer.wrap(this.data).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    @Override
    public synchronized void writeBEShort(long l2, short s2) throws MemoryException {
        ByteBuffer.wrap(this.data).order(ByteOrder.BIG_ENDIAN).putShort(s2);
        this.write(l2, 2, this.data, 0);
    }

    @Override
    public synchronized int readBEInt(long l2) throws MemoryException {
        this.read(l2, 4, this.data, 0);
        return ByteBuffer.wrap(this.data).order(ByteOrder.BIG_ENDIAN).getInt();
    }

    @Override
    public synchronized void writeBEInt(long l2, int n) throws MemoryException {
        ByteBuffer.wrap(this.data).order(ByteOrder.BIG_ENDIAN).putInt(n);
        this.write(l2, 4, this.data, 0);
    }

    @Override
    public synchronized long readBELong(long l2) throws MemoryException {
        this.read(l2, 8, this.data, 0);
        return ByteBuffer.wrap(this.data).order(ByteOrder.BIG_ENDIAN).getLong();
    }

    @Override
    public synchronized void writeBELong(long l2, long l3) throws MemoryException {
        ByteBuffer.wrap(this.data).order(ByteOrder.BIG_ENDIAN).putLong(l3);
        this.write(l2, 8, this.data, 0);
    }

    @Override
    public synchronized short readShort(long l2) throws MemoryException {
        this.read(l2, 2, this.data, 0);
        return ByteBuffer.wrap(this.data).order(this.getStandardEndianess().toByteOrder()).getShort();
    }

    @Override
    public synchronized void writeShort(long l2, short s2) throws MemoryException {
        ByteBuffer.wrap(this.data).order(this.getStandardEndianess().toByteOrder()).putShort(s2);
        this.write(l2, 2, this.data, 0);
    }

    @Override
    public synchronized int readInt(long l2) throws MemoryException {
        this.read(l2, 4, this.data, 0);
        return ByteBuffer.wrap(this.data).order(this.getStandardEndianess().toByteOrder()).getInt();
    }

    @Override
    public synchronized void writeInt(long l2, int n) throws MemoryException {
        ByteBuffer.wrap(this.data).order(this.getStandardEndianess().toByteOrder()).putInt(n);
        this.write(l2, 4, this.data, 0);
    }

    @Override
    public synchronized long readLong(long l2) throws MemoryException {
        this.read(l2, 8, this.data, 0);
        return ByteBuffer.wrap(this.data).order(this.getStandardEndianess().toByteOrder()).getLong();
    }

    @Override
    public synchronized void writeLong(long l2, long l3) throws MemoryException {
        ByteBuffer.wrap(this.data).order(this.getStandardEndianess().toByteOrder()).putLong(l3);
        this.write(l2, 8, this.data, 0);
    }

    @Override
    public synchronized short readShort(long l2, Endianness endianness) throws MemoryException {
        this.read(l2, 2, this.data, 0);
        return ByteBuffer.wrap(this.data).order(endianness.toByteOrder()).getShort();
    }

    @Override
    public synchronized void writeShort(long l2, short s2, Endianness endianness) throws MemoryException {
        ByteBuffer.wrap(this.data).order(endianness.toByteOrder()).putShort(s2);
        this.write(l2, 2, this.data, 0);
    }

    @Override
    public synchronized int readInt(long l2, Endianness endianness) throws MemoryException {
        this.read(l2, 4, this.data, 0);
        return ByteBuffer.wrap(this.data).order(endianness.toByteOrder()).getInt();
    }

    @Override
    public synchronized void writeInt(long l2, int n, Endianness endianness) throws MemoryException {
        ByteBuffer.wrap(this.data).order(endianness.toByteOrder()).putInt(n);
        this.write(l2, 4, this.data, 0);
    }

    @Override
    public synchronized long readLong(long l2, Endianness endianness) throws MemoryException {
        this.read(l2, 8, this.data, 0);
        return ByteBuffer.wrap(this.data).order(endianness.toByteOrder()).getLong();
    }

    @Override
    public synchronized void writeLong(long l2, long l3, Endianness endianness) throws MemoryException {
        ByteBuffer.wrap(this.data).order(endianness.toByteOrder()).putLong(l3);
        this.write(l2, 8, this.data, 0);
    }

    @Override
    public long readPointer(long l2) throws MemoryException {
        switch (this.getSpaceBits()) {
            case 32: {
                return (long)this.readInt(l2) & 0xFFFFFFFFL;
            }
            case 64: {
                return this.readLong(l2);
            }
        }
        throw new MemoryException();
    }

    @Override
    public void writePointer(long l2, long l3) throws MemoryException {
        switch (this.getSpaceBits()) {
            case 32: {
                this.writeInt(l2, (int)l3);
                break;
            }
            case 64: {
                this.writeLong(l2, l3);
                break;
            }
            default: {
                throw new MemoryException();
            }
        }
    }

    protected List<IMemoryPropertyListener> getPropertyListeners() {
        return Collections.emptyList();
    }

    protected List<IMemoryAllocListener> getAllocListeners() {
        return Collections.emptyList();
    }

    protected List<IMemoryFreeListener> getFreeListeners() {
        return Collections.emptyList();
    }

    protected List<IMemoryProtectionListener> getProtectionListeners() {
        return Collections.emptyList();
    }

    protected List<IMemoryWriteListener> getWriteListeners() {
        return Collections.emptyList();
    }

    @Override
    public void addPropertyListener(IMemoryPropertyListener iMemoryPropertyListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePropertyListener(IMemoryPropertyListener iMemoryPropertyListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAllocListener(IMemoryAllocListener iMemoryAllocListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllocListener(IMemoryAllocListener iMemoryAllocListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFreeListener(IMemoryFreeListener iMemoryFreeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFreeListener(IMemoryFreeListener iMemoryFreeListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addProtectionListener(IMemoryProtectionListener iMemoryProtectionListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProtectionListener(IMemoryProtectionListener iMemoryProtectionListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addWriteListener(IMemoryWriteListener iMemoryWriteListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeWriteListener(IMemoryWriteListener iMemoryWriteListener) {
        throw new UnsupportedOperationException();
    }
}

