/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerClassId;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerEntry;
import java.util.ArrayList;
import java.util.List;

public class OptUtil {
    public static <T> List<OptimizerEntry<T>> getOptimizersByClassId(IMasterOptimizer<T> iMasterOptimizer, OptimizerClassId optimizerClassId) {
        ArrayList<OptimizerEntry<T>> arrayList = new ArrayList<OptimizerEntry<T>>();
        List<OptimizerEntry<T>> list = iMasterOptimizer.getRegisteredOptimizers();
        if (list != null) {
            for (OptimizerEntry<T> optimizerEntry : list) {
                IOptimizer<T> iOptimizer = optimizerEntry.getOptimizer();
                if (!optimizerEntry.isEnabled() || iOptimizer.getClassId() != optimizerClassId) continue;
                arrayList.add(optimizerEntry);
            }
        }
        return arrayList;
    }

    public static <T> List<OptimizerEntry<T>> getOnDemandOptimizerEntriesFor(IMasterOptimizer<T> iMasterOptimizer, int n) {
        ArrayList<OptimizerEntry<T>> arrayList = new ArrayList<OptimizerEntry<T>>();
        List<OptimizerEntry<T>> list = iMasterOptimizer.getRegisteredOptimizers(-2);
        if (list != null) {
            for (OptimizerEntry<T> optimizerEntry : list) {
                IOptimizer<T> iOptimizer = optimizerEntry.getOptimizer();
                if (!optimizerEntry.isEnabled() || iOptimizer.getPreferredExecutionStage() != n) continue;
                arrayList.add(optimizerEntry);
            }
        }
        return arrayList;
    }
}

