/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CIdentifierClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICDefinition;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICIdentifier;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.emulator.EmulatorException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.util.base.Assert;
import java.util.HashMap;
import java.util.Map;

public class EmulatorState {
    private static final long BASE_STACK_POINTER_DEFAULT_VALUE = 140737488348408L;
    private IVirtualMemory memory;
    private Map<Integer, Long> registers = new HashMap<Integer, Long>();
    private Integer defaultPointerSize;
    private ITypeManager typeManager;

    public EmulatorState(INativeCodeUnit<?> iNativeCodeUnit) {
        Assert.a(iNativeCodeUnit != null);
        this.typeManager = iNativeCodeUnit.getTypeManager();
        this.defaultPointerSize = iNativeCodeUnit.getMemory().getSpaceBits() / 8;
        this.memory = iNativeCodeUnit.getMemory();
        VirtualMemoryUtil.allocateFillGaps(this.memory, 140737487298560L, 0x110000, 3);
    }

    public Long getVarValue(ICElement iCElement) {
        ICIdentifier iCIdentifier = this.getIdentifier(iCElement);
        if (iCIdentifier.getIdentifierClass() == CIdentifierClass.LOCAL || iCIdentifier.getIdentifierClass() == CIdentifierClass.GLOBAL) {
            return this.readMemory(this.getVarAddress(iCIdentifier), this.getTypeSize(iCIdentifier.getType()));
        }
        return this.registers.get(iCIdentifier.getId());
    }

    public void setVarValue(ICElement iCElement, long l2) {
        ICIdentifier iCIdentifier = this.getIdentifier(iCElement);
        if (iCIdentifier.getIdentifierClass() == CIdentifierClass.LOCAL || iCIdentifier.getIdentifierClass() == CIdentifierClass.GLOBAL) {
            this.writeMemory(this.getVarAddress(iCIdentifier), l2, this.getTypeSize(iCIdentifier.getType()));
        } else {
            int n = this.getTypeSize(iCIdentifier.getType());
            switch (n) {
                case 8: {
                    this.registers.put(iCIdentifier.getId(), l2);
                    break;
                }
                case 4: {
                    this.registers.put(iCIdentifier.getId(), l2 & 0xFFFFFFFFL);
                    break;
                }
                case 2: {
                    this.registers.put(iCIdentifier.getId(), l2 & 0xFFFFL);
                    break;
                }
                case 1: {
                    this.registers.put(iCIdentifier.getId(), l2 & 0xFFL);
                    break;
                }
                default: {
                    throw new EmulatorException(String.format("TBI: register size %d", n));
                }
            }
        }
    }

    private ICIdentifier getIdentifier(ICElement iCElement) {
        if (iCElement instanceof ICIdentifier) {
            return (ICIdentifier)iCElement;
        }
        if (iCElement instanceof ICDefinition) {
            return ((ICDefinition)iCElement).getIdentifier();
        }
        return null;
    }

    public Long getVarAddress(ICIdentifier iCIdentifier) {
        if (iCIdentifier.getIdentifierClass() == CIdentifierClass.LOCAL) {
            return iCIdentifier.getAddress() + 140737488348408L;
        }
        if (iCIdentifier.getIdentifierClass() == CIdentifierClass.GLOBAL) {
            return iCIdentifier.getAddress();
        }
        throw new EmulatorException(String.format("TBI: get address for var (%s)", iCIdentifier));
    }

    public int getTypeSize(ICType iCType) {
        String string = iCType.getSignature();
        INativeType iNativeType = this.typeManager.getType(string);
        if (iNativeType == null) {
            throw new EmulatorException(String.format("ERROR: unknown type (%s)", string));
        }
        return iNativeType.getSize();
    }

    public int getBaseTypeSize(ICType iCType) {
        String string = iCType.getSignature();
        if (string.endsWith("*")) {
            INativeType iNativeType = this.typeManager.getType(iCType.getBaseTypeSignature());
            if (iNativeType == null) {
                throw new EmulatorException(String.format("unknown base type (%s)", string));
            }
            return iNativeType.getSize();
        }
        if (this.defaultPointerSize != null) {
            return this.defaultPointerSize;
        }
        throw new EmulatorException(String.format("not a pointer type (%s)", string));
    }

    public void copyMemory(long l2, long l3, int n) {
        byte[] byArray = new byte[n];
        try {
            this.memory.read(l2, n, byArray, 0);
            this.memory.write(l3, n, byArray, 0);
        }
        catch (MemoryException memoryException) {
            throw new EmulatorException("ERROR: memory copy failed");
        }
    }

    public Long readMemorySafe(long l2, int n) {
        try {
            return this.readMemory(l2, n);
        }
        catch (EmulatorException emulatorException) {
            return 0L;
        }
    }

    public Long readMemory(long l2, int n) {
        Long l3 = 0L;
        try {
            switch (n) {
                case 8: {
                    l3 = this.memory.readLong(l2);
                    break;
                }
                case 4: {
                    l3 = (long)this.memory.readInt(l2) & 0xFFFFFFFFL;
                    break;
                }
                case 2: {
                    l3 = (long)this.memory.readShort(l2) & 0xFFFFL;
                    break;
                }
                case 1: {
                    l3 = (long)this.memory.readByte(l2) & 0xFFL;
                    break;
                }
                default: {
                    throw new EmulatorException(String.format("TBI: read memory size (%d)", n));
                }
            }
        }
        catch (MemoryException memoryException) {
            throw new EmulatorException("ERROR: cant read memory");
        }
        return l3;
    }

    public void writeMemory(long l2, long l3, int n) {
        try {
            switch (n) {
                case 8: {
                    this.memory.writeLong(l2, l3);
                    break;
                }
                case 4: {
                    this.memory.writeInt(l2, (int)l3);
                    break;
                }
                case 2: {
                    this.memory.writeShort(l2, (short)l3);
                    break;
                }
                case 1: {
                    this.memory.writeByte(l2, (byte)l3);
                    break;
                }
                default: {
                    throw new EmulatorException(String.format("TBI: write memory size (%d)", n));
                }
            }
        }
        catch (MemoryException memoryException) {
            throw new EmulatorException("ERROR: cant write memory");
        }
    }

    public void setRegisterValue(int n, long l2) {
        this.registers.put(n, l2);
    }

    public Long getRegisterValue(int n) {
        return this.registers.get(n);
    }

    public Integer getDefaultPointerSize() {
        return this.defaultPointerSize;
    }

    public void setDefaultPointerSize(Integer n) {
        this.defaultPointerSize = n;
    }
}

