/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public enum COperatorType {
    CUSTOM("()", -1, 1),
    NEG("-", 1, 2, Associativity.RIGHT),
    NOT("~", 1, 2, Associativity.RIGHT),
    LOG_NOT("!", 1, 2, Associativity.RIGHT),
    PTR("*", 1, 2, Associativity.RIGHT),
    REF("&", 1, 2, Associativity.RIGHT),
    CAST("(type)", 1, 2, Associativity.RIGHT),
    SIZEOF("sizeof", 1, 2, Associativity.RIGHT),
    LOG_IDENT("", 1, 2, Associativity.RIGHT),
    MUL("*", 2, 3),
    DIV("/", 2, 3),
    REM("%", 2, 3),
    ADD("+", 2, 4),
    SUB("-", 2, 4),
    SHL("<<", 2, 5),
    SHR(">>", 2, 5),
    USHR(">>>", 2, 5),
    GE(">=", 2, 6),
    GT(">", 2, 6),
    LT("<", 2, 6),
    LE("<=", 2, 6),
    EQ("==", 2, 7),
    NE("!=", 2, 7),
    AND("&", 2, 8),
    XOR("^", 2, 9),
    OR("|", 2, 10),
    LOG_AND("&&", 2, 11),
    LOG_OR("||", 2, 12),
    COND("?:", 3, 13, Associativity.RIGHT);

    private final String str;
    private final int opcount;
    private final int prec;
    private final Associativity asso;

    private COperatorType(String string2, int n2, int n3, Associativity associativity) {
        this.str = string2;
        this.opcount = n2;
        this.prec = n3;
        this.asso = associativity;
    }

    private COperatorType(String string2, int n2, int n3) {
        this(string2, n2, n3, Associativity.LEFT);
    }

    private COperatorType() {
        this(null, 0, 0, null);
    }

    public int getOperandCount() {
        return this.opcount;
    }

    public int getPrecedence() {
        return this.prec;
    }

    public Associativity getAssociativity() {
        return this.asso;
    }

    public String toString() {
        return this.str;
    }

    public static enum Associativity {
        LEFT,
        RIGHT;

    }
}

