/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.asm.cfg;

import com.pnfsoftware.jeb.core.units.code.EntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IEntryPointDescription;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CfgVerificationException;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CFGVerifier<InsnType extends IInstruction> {
    private static final ILogger logger = GlobalLog.getLogger(CFGVerifier.class);
    private CFG<InsnType> cfg;

    public CFGVerifier(CFG<InsnType> cFG) {
        this.cfg = cFG;
    }

    protected void customVerification(CFG<InsnType> cFG) throws CfgVerificationException {
    }

    public void verify() throws CfgVerificationException {
        this.customVerification(this.cfg);
        for (BasicBlock<InsnType> basicBlock : this.cfg) {
            List<BasicBlock<InsnType>> list;
            Object object;
            boolean bl2 = false;
            long l2 = basicBlock.getFirstAddress();
            for (int j = 0; j < basicBlock.size(); ++j) {
                object = basicBlock.get(j);
                list = object.getBreakingFlow(basicBlock.getAddressOfInstruction(j));
                if (list.isBroken()) {
                    if (bl2) {
                        throw new CfgVerificationException("Invalid state", new Object[0]);
                    }
                    if (j + list.getDelaySlotCount() + 1 != basicBlock.size()) {
                        throw new CfgVerificationException("branch within BB %08x at @%08x", basicBlock.getFirstAddress(), l2);
                    }
                    this.verifyBranchingInstruction(basicBlock, object, (IFlowInformation)((Object)list));
                    bl2 = true;
                }
                if ((list = object.getRoutineCall(basicBlock.getAddressOfInstruction(j))).isBroken() && (this.cfg.getFlags() & 1) == 0) {
                    if (bl2) {
                        throw new CfgVerificationException("Invalid state", new Object[0]);
                    }
                    if (j + list.getDelaySlotCount() + 1 != basicBlock.size()) {
                        throw new CfgVerificationException("routine call within BB %08x at @%08x", basicBlock.getFirstAddress(), l2);
                    }
                    bl2 = true;
                }
                l2 += (long)object.getSize();
            }
            List<BasicBlock<InsnType>> list2 = basicBlock.getOutputBlocks();
            object = new HashSet<BasicBlock<InsnType>>(list2);
            if (object.size() < list2.size()) {
                throw new CfgVerificationException("duplicate edges out of BB %08x", basicBlock.getFirstAddress());
            }
            list = basicBlock.getInputBlocks();
            HashSet hashSet = new HashSet(list);
            if (hashSet.size() >= list.size()) continue;
            throw new CfgVerificationException("=> Invalid CFG: duplicate edges arriving on BB %08x", basicBlock.getFirstAddress());
        }
        this.verifyDFA(0);
    }

    private void verifyBranchingInstruction(BasicBlock<InsnType> basicBlock, InsnType InsnType, IFlowInformation iFlowInformation) throws CfgVerificationException {
        List<IEntryPointDescription> list = iFlowInformation.getTargets();
        ArrayList<IEntryPointDescription> arrayList = new ArrayList<IEntryPointDescription>();
        for (IEntryPointDescription iEntryPointDescription : list) {
            if (iEntryPointDescription.isUnknownAddress()) continue;
            arrayList.add(iEntryPointDescription);
        }
        if (iFlowInformation.mustComputeFallThrough()) {
            arrayList.add(0, new EntryPointDescription(basicBlock.getEndAddress()));
        }
        if (arrayList.size() != basicBlock.outsize()) {
            throw new CfgVerificationException("number of targets (%d) differ from number of CFG edges (%d) at BB %08x", arrayList.size(), basicBlock.outsize(), basicBlock.getFirstAddress());
        }
        this.verifyFallthrough(basicBlock, arrayList);
        HashSet<IEntryPointDescription> hashSet = new HashSet<IEntryPointDescription>(arrayList);
        if (hashSet.size() < arrayList.size()) {
            throw new CfgVerificationException("duplicate targets for branching instruction at BB %08x", basicBlock.getFirstAddress());
        }
        int n = 0;
        block1: for (IEntryPointDescription iEntryPointDescription : arrayList) {
            for (BasicBlock<InsnType> basicBlock2 : basicBlock.getOutputBlocks()) {
                if (basicBlock2.getFirstAddress() != iEntryPointDescription.getAddress()) continue;
                ++n;
                continue block1;
            }
        }
        if (n != basicBlock.outsize()) {
            throw new CfgVerificationException("branching instruction targets are not synchronized with CFG edges at BB %08x", basicBlock.getFirstAddress());
        }
    }

    private void verifyDFA(int n) throws CfgVerificationException {
        if (this.cfg.dfa == null) {
            return;
        }
        if (!this.cfg.dfa.isValid()) {
            throw new CfgVerificationException("Invalid DFA", new Object[0]);
        }
        String string = this.cfg.format(true, 1, true);
        String string2 = this.cfg.format(true, 2, true);
        this.cfg.doDataFlowAnalysis(true);
        if (!(n != 0 && n != 1 || this.cfg.format(true, 1, true).equals(string))) {
            throw new CfgVerificationException("Invalid DFA (simple chains):\nBefore: %s\nAfter: %s", string, this.cfg.format(true, 1, true));
        }
        if (!(n != 0 && n != 2 || this.cfg.format(true, 2, true).equals(string2))) {
            throw new CfgVerificationException("Invalid DFA (full chains)", new Object[0]);
        }
    }

    private void verifyFallthrough(BasicBlock<InsnType> basicBlock, List<IEntryPointDescription> list) throws CfgVerificationException {
        long l2 = basicBlock.getEndAddress();
        int n = 0;
        for (BasicBlock<InsnType> object : basicBlock.getOutputBlocks()) {
            if (object.getFirstAddress() == l2) {
                if (n != 0) {
                    throw new CfgVerificationException("fallthrough is not the first edge in CFG at BB %08x (%d)", basicBlock.getFirstAddress(), n);
                }
                if (list.isEmpty() || list.get(0).getAddress() == l2) break;
                throw new CfgVerificationException("fallthrough is not the first target at BB %08x (but is correct in the CFG)", basicBlock.getFirstAddress());
            }
            ++n;
        }
        n = 0;
        for (IEntryPointDescription iEntryPointDescription : list) {
            if (iEntryPointDescription.getAddress() == l2) {
                if (n != 0) {
                    throw new CfgVerificationException("fallthrough is not the first target at BB %08x", basicBlock.getFirstAddress());
                }
                if (((BasicBlock)basicBlock.getOutputBlock(0)).getFirstAddress() == l2) break;
                throw new CfgVerificationException("fallthrough is not the first edge in CFG at BB %08x (but is correct in targets)", basicBlock.getFirstAddress());
            }
            ++n;
        }
    }
}

