/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code.android.controlflow;

import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.IVariableInformationProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tracker<InsnType extends ILocatedInstruction> {
    CFG<InsnType> cfg;
    BasicBlock<InsnType> bb;
    Map<Integer, Set<InsnType>> inlist;
    Map<Integer, Set<InsnType>> outlist;

    Tracker(CFG<InsnType> cFG, BasicBlock<InsnType> basicBlock, boolean bl2, boolean bl3) {
        this.cfg = cFG;
        this.bb = basicBlock;
        this.inlist = bl2 ? new HashMap() : null;
        this.outlist = bl3 ? new HashMap() : null;
    }

    void initInlist() {
        if (this.inlist == null) {
            this.inlist = new HashMap<Integer, Set<InsnType>>();
        }
    }

    void initOutlist() {
        if (this.outlist == null) {
            this.outlist = new HashMap<Integer, Set<InsnType>>();
        }
    }

    void prepareLists() {
        if (this.inlist == null) {
            this.inlist = new HashMap<Integer, Set<InsnType>>();
        }
        if (this.outlist == null) {
            this.outlist = new HashMap<Integer, Set<InsnType>>();
        }
    }

    Map<Integer, Set<InsnType>> copyList(Map<Integer, Set<InsnType>> map) {
        HashMap<Integer, Set<InsnType>> hashMap = new HashMap<Integer, Set<InsnType>>();
        for (int n : map.keySet()) {
            hashMap.put(n, new HashSet(map.get(n)));
        }
        return hashMap;
    }

    void addToList(Map<Integer, Set<InsnType>> map, Map<Integer, Set<InsnType>> map2) {
        for (int n : map2.keySet()) {
            Set<InsnType> set = map.get(n);
            if (set == null) {
                set = new HashSet<InsnType>();
                map.put(n, set);
            }
            set.addAll((Collection)map2.get(n));
        }
    }

    boolean compareLists(Map<Integer, Set<InsnType>> map, Map<Integer, Set<InsnType>> map2) {
        for (int n : map.keySet()) {
            Set<InsnType> set = map2.get(n);
            if (set == null) {
                return false;
            }
            if (set.equals(map.get(n))) continue;
            return false;
        }
        return true;
    }

    void applyTransferFunctionLiveRegisters() {
        List list = this.bb.insns;
        this.inlist = this.copyList(this.outlist);
        for (int j = list.size() - 1; j >= 0; --j) {
            ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)list.get(j);
            for (int n : this.cfg.insn_def.get(iLocatedInstruction)) {
                this.inlist.remove(n);
            }
            for (int n : this.cfg.insn_use.get(iLocatedInstruction)) {
                Set<InsnType> set = this.inlist.get(n);
                if (set == null) {
                    set = new HashSet<InsnType>();
                    this.inlist.put(n, set);
                }
                set.add(iLocatedInstruction);
            }
        }
    }

    void applyTransferFunctionReachingRegisters(IVariableInformationProvider iVariableInformationProvider) {
        List list = this.bb.insns;
        this.outlist = this.copyList(this.inlist);
        for (int j = 0; j < list.size(); ++j) {
            ILocatedInstruction iLocatedInstruction = (ILocatedInstruction)list.get(j);
            for (int n : this.cfg.insn_def.get(iLocatedInstruction)) {
                Set<Integer> set;
                if (iVariableInformationProvider != null) {
                    set = iVariableInformationProvider.getSame(n);
                    for (Integer n2 : set) {
                        this.outlist.remove(n2);
                    }
                }
                if ((set = this.outlist.get(n)) == null) {
                    set = new HashSet();
                    this.outlist.put(n, set);
                } else {
                    set.clear();
                }
                set.add((Integer)((Object)iLocatedInstruction));
            }
        }
    }

    private String formatList(Map<Integer, Set<InsnType>> map) {
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int n : map.keySet()) {
            stringBuilder.append(String.format("%d={", n));
            Set<InsnType> set = map.get(n);
            int n2 = 0;
            for (ILocatedInstruction iLocatedInstruction : set) {
                if (n2 > 0) {
                    stringBuilder.append(",");
                }
                if (iLocatedInstruction == null) {
                    stringBuilder.append("-1");
                } else {
                    stringBuilder.append(String.format("%X", iLocatedInstruction.getOffset()));
                }
                ++n2;
            }
            stringBuilder.append("} ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

