/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;

public class CodeUnitUtil {
    private static final ILogger logger = GlobalLog.getLogger(CodeUnitUtil.class);

    public static ICodeMethod getMethodByName(ICodeUnit iCodeUnit, String string, boolean bl2) {
        ICodeMethod iCodeMethod = null;
        ArrayList<ICodeMethod> arrayList = new ArrayList<ICodeMethod>();
        for (ICodeMethod iCodeMethod2 : iCodeUnit.getMethods()) {
            String string2 = iCodeMethod2.getName(true);
            if (string2 == null) continue;
            if (string2.equals(string)) {
                if (iCodeMethod != null) {
                    logger.error("Unit '%s': Two or more methods have the name '%s'", iCodeUnit, string2);
                    return null;
                }
                iCodeMethod = iCodeMethod2;
                continue;
            }
            if (!string2.contains(string)) continue;
            arrayList.add(iCodeMethod2);
        }
        if (iCodeMethod == null && !arrayList.isEmpty()) {
            if (arrayList.size() >= 2 && bl2) {
                return null;
            }
            iCodeMethod = (ICodeMethod)arrayList.get(0);
        }
        return iCodeMethod;
    }

    public static ICodeField getFieldByName(ICodeUnit iCodeUnit, String string, boolean bl2) {
        ICodeField iCodeField = null;
        ArrayList<ICodeField> arrayList = new ArrayList<ICodeField>();
        for (ICodeField iCodeField2 : iCodeUnit.getFields()) {
            String string2 = iCodeField2.getName(true);
            if (string2 == null) continue;
            if (string2.equals(string)) {
                if (iCodeField != null) {
                    logger.error("Unit '%s': Two or more fields have the name '%s'", iCodeUnit, string2);
                    return null;
                }
                iCodeField = iCodeField2;
                continue;
            }
            if (!string2.contains(string)) continue;
            arrayList.add(iCodeField2);
        }
        if (iCodeField == null && !arrayList.isEmpty()) {
            if (arrayList.size() >= 2 && bl2) {
                return null;
            }
            iCodeField = (ICodeField)arrayList.get(0);
        }
        return iCodeField;
    }
}

