/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.code;

import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.ILocatedInstruction;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.List;

@Ser
public class AddressableInstruction<InsnType extends IInstruction>
implements ILocatedInstruction {
    @SerId(value=1)
    private long address;
    @SerId(value=2)
    private InsnType insn;

    public AddressableInstruction(long l2, InsnType InsnType) {
        if (InsnType instanceof ILocatedInstruction) {
            throw new RuntimeException("The instruction type is already addressable");
        }
        this.address = l2;
        this.insn = InsnType;
    }

    public InsnType getInstruction() {
        return this.insn;
    }

    @Override
    public long getOffset() {
        return this.address;
    }

    @Override
    public int getProcessorMode() {
        return this.insn.getProcessorMode();
    }

    @Override
    public int getSize() {
        return this.insn.getSize();
    }

    @Override
    public byte[] getCode() {
        return this.insn.getCode();
    }

    @Override
    public String getPrefix() {
        return this.insn.getPrefix();
    }

    @Override
    public String getMnemonic() {
        return this.insn.getMnemonic();
    }

    @Override
    public IInstructionOperand[] getOperands() {
        return this.insn.getOperands();
    }

    @Override
    public IFlowInformation getBreakingFlow(long l2) {
        return this.insn.getBreakingFlow(l2);
    }

    @Override
    public IFlowInformation getBreakingFlow() {
        return this.getBreakingFlow(this.getOffset());
    }

    @Override
    public IFlowInformation getRoutineCall(long l2) {
        return this.insn.getRoutineCall(l2);
    }

    @Override
    public IFlowInformation getRoutineCall() {
        return this.insn.getRoutineCall(this.getOffset());
    }

    @Override
    public IFlowInformation getIndirectRoutineCall(long l2) {
        return this.insn.getIndirectRoutineCall(l2);
    }

    @Override
    public IFlowInformation getIndirectRoutineCall() {
        return this.insn.getIndirectRoutineCall(this.getOffset());
    }

    @Override
    public void getDefUse(List<Integer> list, List<Integer> list2, Object object) {
        this.insn.getDefUse(list, list2, object);
    }

    @Override
    public boolean canThrow() {
        return this.insn.canThrow();
    }

    @Override
    public boolean isConditional() {
        return this.insn.isConditional();
    }

    @Override
    public String format(Object object) {
        return this.insn.format(object);
    }

    public String toString() {
        return String.format("%Xh:%s", this.address, this.insn);
    }
}

