/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units;

import com.pnfsoftware.jeb.core.units.IMetadataGroup;
import com.pnfsoftware.jeb.core.units.IMetadataManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class MetadataManager
implements IMetadataManager {
    @SerId(value=1)
    private List<IMetadataGroup> groups = new ArrayList<IMetadataGroup>();

    public List<IMetadataGroup> getGroups() {
        return this.groups;
    }

    @Override
    public int getGroupCount() {
        return this.getGroups().size();
    }

    @Override
    public IMetadataGroup getGroupByName(String string) {
        for (IMetadataGroup iMetadataGroup : this.getGroups()) {
            if (!Strings.equals(iMetadataGroup.getName(), string)) continue;
            return iMetadataGroup;
        }
        return null;
    }

    @Override
    public boolean addGroup(IMetadataGroup iMetadataGroup) {
        return this.insertGroup(this.getGroupCount(), iMetadataGroup);
    }

    @Override
    public boolean insertGroup(int n, IMetadataGroup iMetadataGroup) {
        if (n < 0 || n > this.getGroupCount()) {
            return false;
        }
        String string = iMetadataGroup.getName();
        if (string == null || string.isEmpty() || this.getGroupByName(string) != null) {
            return false;
        }
        this.getGroups().add(n, iMetadataGroup);
        return true;
    }

    @Override
    public boolean removeGroup(int n) {
        if (n < 0 || n >= this.getGroupCount()) {
            return false;
        }
        this.getGroups().remove(n);
        return true;
    }

    @Override
    public boolean removeGroupByName(String string) {
        int n = 0;
        for (IMetadataGroup iMetadataGroup : this.getGroups()) {
            if (Strings.equals(iMetadataGroup.getName(), string)) break;
            ++n;
        }
        if (n >= this.getGroups().size()) {
            return false;
        }
        this.getGroups().remove(n);
        return true;
    }
}

