/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.text.impl;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IActionableTextItem;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;

@Ser
@SerVersion(value=1)
public class TextItem
implements IActionableTextItem {
    @SerId(value=1)
    private int offset;
    @SerId(value=2)
    private int length;
    @SerId(value=3)
    private ItemClassIdentifiers classId;
    @SerId(value=4)
    private long itemId;
    @SerId(value=5)
    private int flags;
    @SerId(value=6, version=1)
    private ILine line;

    public TextItem(int n, int n2) {
        this(n, n2, null, 0L, 0);
    }

    public TextItem(int n, int n2, ItemClassIdentifiers itemClassIdentifiers) {
        this(n, n2, itemClassIdentifiers, 0L, 0);
    }

    public TextItem(int n, int n2, ItemClassIdentifiers itemClassIdentifiers, long l2, int n3) {
        this.offset = n;
        this.length = n2;
        this.classId = itemClassIdentifiers;
        this.itemId = l2;
        this.flags = n3;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    @Override
    public int getOffsetEnd() {
        return this.getOffset() + this.getLength();
    }

    @Override
    public ItemClassIdentifiers getClassId() {
        return this.classId;
    }

    public void setClassId(ItemClassIdentifiers itemClassIdentifiers) {
        this.classId = itemClassIdentifiers;
    }

    @Override
    public long getItemId() {
        return this.itemId;
    }

    public void setItemId(long l2) {
        this.itemId = l2;
    }

    @Override
    public int getItemFlags() {
        return this.flags;
    }

    public void setItemFlags(int n) {
        this.flags = n;
    }

    @Override
    public ILine getLine() {
        return this.line;
    }

    public void setLine(ILine iLine) {
        if (this.line != null && this.line != iLine) {
            throw new IllegalStateException("This text item already belong to the line: " + this.line);
        }
        this.line = iLine;
    }

    @Override
    public String getText() {
        if (this.line == null) {
            return null;
        }
        return this.line.getText().subSequence(this.offset, this.offset + this.length).toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id=").append(Long.toHexString(this.itemId).toUpperCase());
        stringBuilder.append("h,(o=").append(this.offset);
        stringBuilder.append(",l=").append(this.length);
        stringBuilder.append("),cid=").append((Object)this.classId);
        stringBuilder.append(",flags=").append(Long.toHexString(this.flags).toUpperCase()).append("h]");
        return stringBuilder.toString();
    }
}

