/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output.code;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.AssemblyItem;
import com.pnfsoftware.jeb.core.output.code.CodeAnchor;
import com.pnfsoftware.jeb.core.output.code.CodeLine;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.TextMark;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public abstract class CodeDocumentPart
implements ITextDocumentPart {
    private List<CodeLine> lines;
    private List<CodeAnchor> anchors;
    private long currentAnchorId;
    private boolean padding;
    private String paddingString;
    private int indentLevel;
    private String indentString;
    private Deque<ICodeCoordinates> linecoordstack = new ArrayDeque<ICodeCoordinates>();
    private Deque<ICodeCoordinates> coordstack = new ArrayDeque<ICodeCoordinates>();

    public CodeDocumentPart(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Invalid anchor identifier: " + l2);
        }
        this.padding = false;
        this.paddingString = "          ";
        this.indentLevel = 0;
        this.indentString = "    ";
        this.lines = new ArrayList<CodeLine>();
        this.lines.add(new CodeLine());
        this.anchors = new ArrayList<CodeAnchor>();
        this.currentAnchorId = l2;
    }

    public List<CodeLine> getLines() {
        return this.lines.subList(0, this.lines.size() - 1);
    }

    public CodeLine getLine(int n) {
        if (n < 0 || n + 1 >= this.lines.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.lines.get(n);
    }

    public List<CodeAnchor> getAnchors() {
        return this.anchors;
    }

    private void checkRegisterAnchor(long l2, int n) {
        if (l2 < 0L || n < 0) {
            throw new IllegalArgumentException(String.format("Can not register anchor id %d with line index %d: need positive values.", l2, n));
        }
        if (!this.anchors.isEmpty()) {
            CodeAnchor codeAnchor = this.anchors.get(this.anchors.size() - 1);
            if (codeAnchor.getIdentifier() >= l2) {
                throw new IllegalArgumentException(String.format("Can not register anchor id %d because its id is overlapping previously defined anchor id %d", l2, codeAnchor.getIdentifier()));
            }
            if (codeAnchor.getLineIndex() >= n) {
                throw new IllegalArgumentException(String.format("Can not register anchor id %d because the line index %d is overlapping previously defined line index %d", l2, n, codeAnchor.getLineIndex()));
            }
        }
    }

    public void registerAnchor(String string) {
        int n = this.getCurrentLineIndex();
        this.checkRegisterAnchor(this.currentAnchorId, n);
        this.anchors.add(new CodeAnchor(this.currentAnchorId, n, string));
        ++this.currentAnchorId;
    }

    public void registerAnchor(long l2, String string) {
        int n = this.getCurrentLineIndex();
        this.checkRegisterAnchor(l2, n);
        this.anchors.add(new CodeAnchor(l2, n, string));
        this.currentAnchorId = l2 + 1L;
    }

    public CodeAnchor getCurrentAnchor() {
        return this.anchors.get(this.anchors.size() - 1);
    }

    public int getLineCount() {
        return this.lines.size() - 1;
    }

    public int getCurrentLineIndex() {
        return this.lines.size() - 1;
    }

    public int getLastLineIndex() {
        return this.lines.size() - 2;
    }

    public CodeLine getCurrentLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public int getCurrentLineLength() {
        return this.getCurrentLine().getText().length();
    }

    public boolean isCurrentLineEmpty() {
        return this.getCurrentLine().isEmpty();
    }

    public void setIndentationString(String string) {
        this.indentString = string;
    }

    public String getIndentationString() {
        return this.indentString;
    }

    public int getIndentationLevel() {
        return this.indentLevel;
    }

    public void setPaddingString(String string) {
        this.paddingString = string;
    }

    public void resetPaddingString() {
        this.paddingString = "";
    }

    public void enablePadding() {
        this.padding = true;
    }

    public void disablePadding() {
        this.padding = false;
    }

    public void indentReset() {
        this.indentLevel = 0;
    }

    public int getIndententionLevel() {
        return this.indentLevel;
    }

    public void setIndentationLevel(int n) {
        this.indentLevel = n;
    }

    public void incrementIndentationLevel() {
        ++this.indentLevel;
    }

    public void decrementIndentationLevel() {
        --this.indentLevel;
    }

    public void append(String string) {
        string = Strings.replaceNewLines(string, "/");
        CodeLine codeLine = this.getCurrentLine();
        if (codeLine.isEmpty()) {
            if (this.padding) {
                codeLine.append(this.paddingString);
            }
            for (int j = 0; j < this.indentLevel; ++j) {
                codeLine.append(this.indentString);
            }
        }
        codeLine.append(string);
    }

    public void appendMulti(String string) {
        int n = 0;
        for (String string2 : Strings.splitLines(string)) {
            if (n >= 1) {
                this.eol();
            }
            this.append(string2);
            ++n;
        }
    }

    public void space() {
        this.append(" ");
    }

    public void space(int n) {
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                stringBuilder.append(' ');
            }
            this.append(stringBuilder.toString());
        }
    }

    public void eol(ICodeCoordinates iCodeCoordinates) {
        this.lines.get(this.lines.size() - 1).setLineCoordinates(iCodeCoordinates);
        this.lines.add(new CodeLine());
        this.registerCurrentCoordinates();
    }

    public void eol() {
        this.lines.add(new CodeLine());
        this.registerCurrentCoordinates();
    }

    public void appendAndRecord(String string, ItemClassIdentifiers itemClassIdentifiers) {
        this.appendAndRecord(string, itemClassIdentifiers, 0L, 0);
    }

    public void appendAndRecord(String string, ItemClassIdentifiers itemClassIdentifiers, long l2) {
        this.appendAndRecord(string, itemClassIdentifiers, l2, 0);
    }

    public void appendAndRecord(String string, ItemClassIdentifiers itemClassIdentifiers, long l2, int n) {
        if (string == null) {
            string = Strings.safe(string);
        }
        this.append(string);
        CodeLine codeLine = this.getCurrentLine();
        int n2 = string.length();
        int n3 = codeLine.getText().length() - n2;
        AssemblyItem assemblyItem = new AssemblyItem(n3, n2, itemClassIdentifiers, l2, n);
        codeLine.addItem(assemblyItem);
    }

    public void recordLineCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.linecoordstack.push(iCodeCoordinates);
    }

    public void unrecordLineCoordinates() {
        this.linecoordstack.pop();
    }

    public ICodeCoordinates getCurrentLineCoordinates() {
        return this.linecoordstack.peek();
    }

    public void recordCurrentCoordinates(ICodeCoordinates iCodeCoordinates) {
        this.coordstack.push(iCodeCoordinates);
        this.registerCurrentCoordinates();
    }

    public void unrecordCurrentCoordinates() {
        this.coordstack.pop();
        this.registerCurrentCoordinates();
    }

    public ICodeCoordinates getCurrentCoordinates() {
        return this.coordstack.peek();
    }

    private void registerCurrentCoordinates() {
        ICodeCoordinates iCodeCoordinates = this.coordstack.peek();
        this.getCurrentLine().setCoordinates(iCodeCoordinates);
    }

    public void validate() {
        if (!this.coordstack.isEmpty()) {
            throw new JebRuntimeException("Invalid coords at anchor " + this.currentAnchorId);
        }
        if (!this.isCurrentLineEmpty()) {
            throw new JebRuntimeException("Current line is not empty at anchor " + this.currentAnchorId);
        }
    }

    public void prependCodePart(CodeDocumentPart codeDocumentPart) {
        long l2;
        long l3 = l2 = this.anchors.isEmpty() ? this.currentAnchorId : this.anchors.get(0).getIdentifier();
        if (codeDocumentPart.currentAnchorId > l2) {
            throw new IllegalStateException(Strings.f("Can not prepend code with current anchor %d before anchor %d", codeDocumentPart.currentAnchorId, l2));
        }
        ArrayList<CodeAnchor> arrayList = new ArrayList<CodeAnchor>(codeDocumentPart.anchors);
        for (CodeAnchor codeAnchor : this.anchors) {
            codeAnchor.setLineindex(codeAnchor.getLineIndex() + codeDocumentPart.getLineCount());
        }
        arrayList.addAll(this.anchors);
        this.anchors = arrayList;
        ArrayList<CodeLine> arrayList2 = new ArrayList<CodeLine>(codeDocumentPart.lines.subList(0, codeDocumentPart.lines.size() - 1));
        arrayList2.addAll(this.lines);
        this.lines = arrayList2;
    }

    public boolean moveLine(int n, int n2) {
        if (this.getLineCount() <= 1) {
            return false;
        }
        int n3 = this.getCurrentLineIndex();
        if (n == n2 || n < 0 || n >= n3 || n2 < 0 || n2 >= n3) {
            return false;
        }
        CodeLine codeLine = this.lines.remove(n);
        if (n2 < n) {
            this.lines.add(n2, codeLine);
        } else {
            this.lines.add(n2 - 1, codeLine);
        }
        return true;
    }

    public boolean moveLastLine(int n) {
        return this.moveLine(this.getLastLineIndex(), n);
    }

    public void markCurrentPosition(String string, Object object) {
        this.getCurrentLine().addMark(new TextMark(this.getCurrentLineLength(), string, object));
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CodeLine codeLine : this.lines) {
            stringBuilder.append(codeLine.getText());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("Lines:%d,Current:\"%s\"", this.getLineCount(), this.getCurrentLine().getText());
    }
}

