/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.output;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.TreeMap;

public class UnitItemIdGenerator {
    private static final ILogger logger = GlobalLog.getLogger(UnitItemIdGenerator.class);
    private ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private HashMap<Ref, Integer> map = new HashMap();
    private TreeMap<Integer, Ref> rmap = new TreeMap();

    private void expunge() {
        Ref ref;
        while ((ref = (Ref)this.refQueue.poll()) != null) {
            Integer n = this.map.remove(ref);
            Assert.a(n != null);
            this.rmap.remove(n);
        }
    }

    public long generate(Object object) {
        this.expunge();
        if (object == null) {
            return 0L;
        }
        Ref ref = new Ref(object, this.refQueue);
        Integer n = this.map.get(ref);
        if (n == null) {
            n = this.rmap.isEmpty() ? 1 : this.rmap.lastKey() + 1;
            this.map.put(ref, n);
            this.rmap.put(n, ref);
        }
        Assert.a(n != 0, "Too many actionable items were generated by this unit. Thank you for reporting this error.");
        long l2 = 0xFE00000000000000L | (long)n.intValue() & 0xFFFFFFFFL;
        return l2;
    }

    public Object retrieve(long l2) {
        this.expunge();
        if ((l2 & 0xFE00000000000000L) != -144115188075855872L) {
            return null;
        }
        Integer n = (int)l2;
        Ref ref = this.rmap.get(n);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    private static class Ref
    extends WeakReference<Object> {
        private final int hashCode;

        Ref(Object object, ReferenceQueue<Object> referenceQueue) {
            super(object, referenceQueue);
            this.hashCode = object == null ? 0 : System.identityHashCode(object);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)object;
            Object t = this.get();
            return t != null && t == ref.get();
        }
    }
}

