/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.core.dao.IFileDatabaseReader;
import com.pnfsoftware.jeb.core.dao.impl.JEB2FileDatabaseWriter;
import com.pnfsoftware.jeb.util.io.StreamWrappers;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class JEB2FileDatabaseReader
implements IFileDatabaseReader {
    private static final ILogger logger = GlobalLog.getLogger(JEB2FileDatabaseReader.class);
    private File file;
    private RandomAccessFile fa;
    private List<RecordDescription> records = new ArrayList<RecordDescription>();

    public JEB2FileDatabaseReader(File file) throws IOException {
        this.file = file;
        this.fa = new RandomAccessFile(file, "r");
        if (this.readIntLE() != 843203658) {
            throw new IOException();
        }
        this.fa.skipBytes(28);
        try {
            while (this.fa.getFilePointer() + 8L <= this.fa.length()) {
                int n = this.readIntLE();
                int n2 = n & 0xFFFFFF;
                int n3 = n >> 24 & 0xFF;
                int n4 = this.readIntLE();
                long l2 = this.fa.getFilePointer();
                this.records.add(new RecordDescription(n2, n3, l2, n4));
                this.fa.skipBytes(n4);
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException);
        }
        this.fa.seek(32L);
    }

    @Override
    public boolean hasBackingFile() {
        return true;
    }

    @Override
    public File getBackingFile() {
        return this.file;
    }

    @Override
    public List<RecordDescription> getRecordDescriptions() {
        return this.records;
    }

    @Override
    public RecordDescription getRecordDescription(int n) {
        for (RecordDescription recordDescription : this.records) {
            if (recordDescription.getType() != n) continue;
            return recordDescription;
        }
        return null;
    }

    @Override
    public InputStream getRecord(int n) throws IOException {
        RecordDescription recordDescription = this.getRecordDescription(n);
        if (recordDescription == null) {
            throw new IOException(String.format("A record of type %X was not found", n));
        }
        return this.getRecord(recordDescription);
    }

    @Override
    public InputStream getRecord(RecordDescription recordDescription) throws IOException {
        boolean bl2 = (recordDescription.flags & 1) != 0;
        boolean bl3 = (recordDescription.flags & 2) != 0;
        int n = recordDescription.dataSize;
        this.fa.seek(recordDescription.dataOffset);
        final long l2 = this.fa.getFilePointer() + (long)n;
        InputStream inputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                if (JEB2FileDatabaseReader.this.fa.getFilePointer() >= l2) {
                    return -1;
                }
                return JEB2FileDatabaseReader.this.fa.read();
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (n2 == 0) {
                    return 0;
                }
                int n3 = (int)(l2 - JEB2FileDatabaseReader.this.fa.getFilePointer());
                if (n3 <= 0) {
                    return -1;
                }
                if (n3 < n2) {
                    n2 = n3;
                }
                return JEB2FileDatabaseReader.this.fa.read(byArray, n, n2);
            }

            @Override
            public int available() throws IOException {
                return (int)(l2 - JEB2FileDatabaseReader.this.fa.getFilePointer());
            }
        };
        inputStream = new BufferedInputStream(inputStream, JEB2FileDatabaseWriter.getFileBufferSize());
        if (bl3) {
            int n2 = recordDescription.type & 0xFFFFFF | (recordDescription.flags & 0xFF) << 24;
            byte[] byArray = JEB2FileDatabaseWriter.getRecordEncryptionKey(n2);
            inputStream = StreamWrappers.getDecryptedStream(inputStream, byArray);
        }
        if (bl2) {
            inputStream = StreamWrappers.getUncompressedStream(inputStream);
        }
        return inputStream;
    }

    @Override
    public void close() throws IOException {
        this.fa.close();
        this.fa = null;
    }

    private int readIntLE() throws IOException {
        int n = this.fa.readInt();
        n = n << 24 | n << 8 & 0xFF0000 | n >>> 8 & 0xFF00 | n >>> 24;
        return n;
    }

    public static class RecordDescription {
        int type;
        int flags;
        long dataOffset;
        int dataSize;

        public RecordDescription(int n, int n2, long l2, int n3) {
            this.type = n;
            this.flags = n2;
            this.dataOffset = l2;
            this.dataSize = n3;
        }

        public int getType() {
            return this.type;
        }

        public int getFlags() {
            return this.flags;
        }

        public long getOffsetToData() {
            return this.dataOffset;
        }

        public int getSizeOfData() {
            return this.dataSize;
        }
    }
}

