/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.core.dao.IFileDatabase;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseReader;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseWriter;
import com.pnfsoftware.jeb.core.dao.impl.JEB2FileDatabaseReader;
import com.pnfsoftware.jeb.core.dao.impl.JEB2FileDatabaseWriter;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.io.LEDataOutputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JEB2FileDatabase
implements IFileDatabase {
    private static final ILogger logger = GlobalLog.getLogger(JEB2FileDatabase.class);
    public static final String EXTENSION = ".jdb2";
    public static final int MARKER = 843203658;
    public static final int TYPE_PROJECT = 4870736;
    public static final int TYPE_QSTATES = 4932433;
    public static final int TYPE_ARTIFACTS = 5526081;
    public static final int TYPE_PROJECT_METADATA = 5066832;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_COMPRESS = 1;
    public static final int FLAG_ENCRYPT = 2;
    static final int FLAGS_MASK = -4;
    private File base;

    public JEB2FileDatabase(String string) {
        this.base = new File(string);
        if (!this.base.exists() && !this.base.mkdirs()) {
            throw new RuntimeException("Cannot create directory");
        }
        if (!this.base.isDirectory()) {
            throw new RuntimeException("The specified path is not a directory");
        }
    }

    private String buildStoreKey(String string, int n) {
        return String.format("%s", string);
    }

    private File keyToFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key should not be null");
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.base, string);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveFile(String string, int n, byte[] byArray) {
        String string2 = this.buildStoreKey(string, n);
        File file = this.keyToFile(string2);
        try (LEDataOutputStream lEDataOutputStream = new LEDataOutputStream(new DataOutputStream(new FileOutputStream(file)));){
            boolean bl2;
            lEDataOutputStream.writeInt(843203658);
            for (bl2 = true; bl2 < 8 != 0; bl2 += 1) {
                lEDataOutputStream.writeInt(0);
            }
            lEDataOutputStream.writeInt(4870736);
            lEDataOutputStream.writeInt(byArray.length);
            lEDataOutputStream.write(byArray);
            bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] loadFile(String string, int n) {
        String string2 = this.buildStoreKey(string, n);
        File file = this.keyToFile(string2);
        if (!file.exists()) {
            return null;
        }
        try (LEDataInputStream lEDataInputStream = new LEDataInputStream(new DataInputStream(new FileInputStream(file)));){
            if (lEDataInputStream.readInt() != 843203658) {
                throw new IOException("Illegal JDB2 marker");
            }
            lEDataInputStream.skipBytes(28);
            if (lEDataInputStream.readInt() != 4870736) {
                throw new IOException("Illegal JDB2 block: a project entry was expected");
            }
            int n2 = lEDataInputStream.readInt();
            byte[] byArray2 = new byte[n2];
            int n3 = lEDataInputStream.read(byArray2, 0, n2);
            if (n3 != n2) {
                throw new IOException(String.format("Illegal JDB2 block size: %d bytes were expected, got %d", n2, n3));
            }
            byte[] byArray = byArray2;
            return byArray;
        }
        catch (Exception exception) {
            logger.catching(exception);
            return null;
        }
    }

    @Override
    public boolean hasFile(String string, int n) {
        File file = this.keyToFile(string);
        return file.exists();
    }

    @Override
    public boolean deleteFile(String string, int n) {
        File file = this.keyToFile(string);
        return file.delete();
    }

    @Override
    public InputStream getFileReader(String string) throws FileNotFoundException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new FileInputStream(file);
    }

    @Override
    public OutputStream getFileWriter(String string) throws FileNotFoundException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new FileOutputStream(file);
    }

    @Override
    public IFileDatabaseWriter getDatabaseWriter(String string) throws IOException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new JEB2FileDatabaseWriter(file);
    }

    @Override
    public IFileDatabaseReader getDatabaseReader(String string) throws IOException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new JEB2FileDatabaseReader(file);
    }
}

