/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.script.JebPythonPluginFactory;
import com.pnfsoftware.jeb.client.script.JythonDynamicWrapper;
import com.pnfsoftware.jeb.client.script.JythonUtil;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class JebPythonPluginService {
    private static final ILogger logger = GlobalLog.getLogger(JebPythonPluginService.class);
    private File pyLibDir;
    private JythonDynamicWrapper j;
    Object singleInterpreter;
    Set<String> syspaths = new LinkedHashSet<String>();
    Set<String> loadedPluginFiles = new LinkedHashSet<String>();
    Set<String> loadedPluginNames = new LinkedHashSet<String>();

    public JebPythonPluginService(File file) throws JebException {
        if (file == null || !file.isDirectory()) {
            throw new JebException(String.format("Path \"%s\" is not a directory", file));
        }
        this.pyLibDir = file;
    }

    public JebPythonPluginService(String string) throws JebException {
        if (Strings.isBlank(string)) {
            throw new IllegalArgumentException("The Python plugins library path cannot be null or empty");
        }
        this.pyLibDir = new File(string);
        if (!this.pyLibDir.exists()) {
            if (!this.pyLibDir.mkdir()) {
                throw new JebException(String.format("Cannot create directory \"%s\"", string));
            }
        } else if (!this.pyLibDir.isDirectory()) {
            throw new JebException(String.format("Path \"%s\" is not a directory", string));
        }
    }

    private synchronized void initJython() throws JebException {
        if (this.j != null) {
            throw new IllegalStateException();
        }
        logger.info("JEB Python plugins are detected: Initializing Jython...", new Object[0]);
        File file = JythonUtil.findJythonJar(this.pyLibDir);
        try {
            this.j = new JythonDynamicWrapper(file);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new JebException("Invalid Jython package", reflectiveOperationException);
        }
        Properties properties = new Properties();
        properties.put("python.home", this.j.getJythonJarFile().getParent());
        properties.put("python.console.encoding", "UTF-8");
        properties.put("python.security.respectJavaAccessibility", "false");
        Properties properties2 = System.getProperties();
        try {
            this.j.PythonInterpreter_initialize(properties2, properties, new String[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new JebException("Jython initialization error", reflectiveOperationException);
        }
    }

    public synchronized JebPythonPluginFactory createFactory(String string) throws JebException {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            if (!file.isAbsolute()) {
                file = new File(this.pyLibDir, string);
            }
            if (!file.exists()) {
                throw new JebException("The plugin was not found: " + string);
            }
        }
        if (!(string2 = file.getName()).toLowerCase().endsWith(".py")) {
            throw new JebException("Expected a '.py' extension for Python plugin");
        }
        if (this.j == null) {
            this.initJython();
        }
        JebPythonPluginFactory jebPythonPluginFactory = null;
        try {
            String string3 = string2.substring(0, string2.length() - 3);
            jebPythonPluginFactory = new JebPythonPluginFactory(this.j, file.getAbsoluteFile().getParent(), string3);
            return jebPythonPluginFactory;
        }
        catch (RuntimeException runtimeException) {
            try {
                if (jebPythonPluginFactory != null) {
                    jebPythonPluginFactory.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new JebException(runtimeException.getMessage());
        }
    }

    public synchronized Class<? extends IPlugin> getPluginClass(String string) throws JebException {
        try {
            Object object;
            File file = new File(string);
            if (!file.exists()) {
                if (!file.isAbsolute()) {
                    file = new File(this.pyLibDir, string);
                }
                if (!file.exists()) {
                    throw new JebException("The plugin was not found: " + string);
                }
            }
            String string2 = file.getParent();
            String string3 = file.getName().replaceFirst("\\.py", "");
            if (this.loadedPluginFiles.contains(string)) {
                throw new IllegalStateException("A Python plugin was already loaded from file: " + string);
            }
            if (this.loadedPluginNames.contains(string3)) {
                throw new IllegalStateException("A Python plugin was already loaded with the name: " + string3);
            }
            long l2 = System.currentTimeMillis();
            if (this.j == null) {
                this.initJython();
            }
            if (this.singleInterpreter == null) {
                this.singleInterpreter = this.j.PythonInterpreter_init(null, this.j.PySystemState_init());
                object = new LogRedirectionOutputStream();
                this.j.PythonInterpreter_setOut(this.singleInterpreter, (Writer)object);
                this.j.PythonInterpreter_exec(this.singleInterpreter, "import sys");
            }
            if (!this.syspaths.contains(string2)) {
                this.syspaths.add(string2);
                this.j.PythonInterpreter_exec(this.singleInterpreter, String.format("sys.path.append(\"%s\")", string2.replace("\\", "\\\\")));
            }
            this.j.PythonInterpreter_exec(this.singleInterpreter, String.format("from %s import %s", string3, string3));
            object = this.j.PythonInterpreter_get(this.singleInterpreter, string3);
            Class clazz = (Class)this.j.PyObject_tojava(object, Class.class);
            this.loadedPluginFiles.add(string);
            this.loadedPluginNames.add(string3);
            logger.info("%s: Python plugin loaded in %dms", string3, System.currentTimeMillis() - l2);
            return clazz;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

