/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.api;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;

public class OperationRequest {
    private Operation op;
    private long t0;
    private long t1;
    private Boolean result;
    private WeakIdentityHashMap<IOperable, Long> processors;

    public OperationRequest(Operation operation) {
        if (operation == null) {
            throw new NullPointerException("Null operation");
        }
        this.op = operation;
        this.t0 = System.nanoTime();
    }

    public Operation getOperation() {
        return this.op;
    }

    public boolean prepare(IOperable iOperable) {
        if (this.processors == null) {
            this.processors = new WeakIdentityHashMap();
        }
        if (this.processors.get(iOperable) != null) {
            return false;
        }
        this.processors.put(iOperable, System.nanoTime());
        return true;
    }

    public void setResult(boolean bl2) {
        this.result = bl2;
        this.t1 = System.nanoTime();
    }

    public boolean success() {
        return this.result != null && this.result != false;
    }

    public boolean done() {
        return this.result != null;
    }

    public boolean proceed() {
        return this.result == null;
    }

    public long duration() {
        if (this.result == null) {
            return (System.nanoTime() - this.t0) / 1000000L;
        }
        return (this.t1 - this.t0) / 1000000L;
    }
}

