/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.client.AbstractClientContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.SystemInformation;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.SizeFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ErrorLogGenerator {
    public static final int ERRORLOG_VERSION = 2;
    private Throwable t;
    private LinkedHashMap<String, String> records = new LinkedHashMap();
    private String timestamp;

    public ErrorLogGenerator(Throwable throwable) {
        Runtime runtime = Runtime.getRuntime();
        this.t = throwable;
        this.timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        this.addRecord("logversion", 2);
        this.addRecord("product", "JEB");
        this.addRecord("timestamp", this.timestamp);
        this.addRecord("version", AbstractClientContext.app_ver);
        this.addRecord("userid", Licensing.user_id);
        this.addRecord("licenseid", Licensing.license_id);
        this.addRecord("build", Licensing.buildkey);
        this.addRecord("system", SystemInformation.osname + " " + SystemInformation.osversion + " " + SystemInformation.osarch);
        this.addRecord("java", SystemInformation.javavendor + " " + SystemInformation.javaversion);
        this.addRecord("locale", SystemInformation.localeinfo);
        this.addRecord("memory-usage", String.format("used=%s,alloc=%s,max=%s", SizeFormatter.formatByteSize(runtime.totalMemory() - runtime.freeMemory()), SizeFormatter.formatByteSize(runtime.totalMemory()), SizeFormatter.formatByteSize(runtime.maxMemory())));
        this.addRecord("stacktrace", Throwables.formatStacktrace(throwable));
    }

    public void recordEnginesInformation(IEnginesContext iEnginesContext) {
        List<String> list = this.generatePluginsList(iEnginesContext.getEnginesPlugins());
        this.addRecord("backend-plugins-generic", Strings.joinList(list));
        list = this.generatePluginsList(iEnginesContext.getUnitIdentifiers());
        this.addRecord("backend-plugins-parsers", Strings.joinList(list));
    }

    private List<String> generatePluginsList(List<? extends IPlugin> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IPlugin iPlugin : list) {
            IPluginInformation iPluginInformation = iPlugin.getPluginInformation();
            if (iPluginInformation == null) {
                arrayList.add("<unspecified-plugin>");
                continue;
            }
            arrayList.add(String.format("%s:%s", Strings.safe(iPluginInformation.getName(), "<no-name>"), Strings.safe(iPluginInformation.getVersion(), "no-version")));
        }
        return arrayList;
    }

    public LinkedHashMap<String, String> getRecords() {
        return this.records;
    }

    public String addRecord(String string, Object object) {
        int n = 0;
        String string2 = string;
        while (this.records.containsKey(string2)) {
            string2 = string + "-" + ++n;
        }
        this.records.put(string2, Strings.toString(object));
        return string2;
    }

    public boolean setRecord(String string, Object object) {
        return this.records.put(string, Strings.toString(object)) == null;
    }

    public boolean removeRecord(String string) {
        return this.records.remove(string) != null;
    }

    public Throwable getThrowable() {
        return this.t;
    }

    public String getLog() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.records.entrySet()) {
            stringBuilder.append(String.format("%s: %s\n", Strings.urlencodeUTF8(entry.getKey()), Strings.urlencodeUTF8(entry.getValue())));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getLog();
    }

    public String dumpTo(String string) {
        return this.dumpTo(string, null);
    }

    public String dumpTo(String string, String string2) {
        if (string2 == null) {
            string2 = String.format("jeb_errorlog_%s.txt", this.timestamp);
        }
        File file = new File(string, string2);
        try {
            IO.writeFile(file, Strings.encodeUTF8(this.getLog()));
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

