/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.client.AbstractClientContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.SystemInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import com.pnfsoftware.jeb.util.net.NetProxyInfo;
import com.pnfsoftware.jeb.util.net.URLUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jeb.util.serialization.annotations.SerStaticOk;
import com.pnfsoftware.jebglobal.Do;
import com.pnfsoftware.jebglobal.GW;
import com.pnfsoftware.jebglobal.LC;
import com.pnfsoftware.jebglobal.Ls;
import com.pnfsoftware.jebglobal.qZ;
import com.pnfsoftware.jebglobal.wk;
import java.io.File;
import java.net.URL;

@SerDisabled
public abstract class AbstractContext
extends EventSource {
    private static final ILogger logger = GlobalLog.getLogger(AbstractContext.class);
    @SerStaticOk
    public static final Version app_ver = new Version(3, 7, 0, 201909272058L, 0);
    public static final Integer app_channel_override = null;
    public static final String app_name = "JEB";
    public static final String app_description = "Interactive Decompilation for Software Analysis";
    public static final String app_company = "PNF Software, Inc.";
    public static final String app_dates = "2015-2019";
    public static final String app_domain = "pnfsoftware.com";
    public static final String app_website = "https://www.pnfsoftware.com";
    public static final String app_licensing_backup = "https://lise.pnfsoftware.com";
    public static final String app_url_purchase = "https://www.pnfsoftware.com/jeb/buy";
    public static final String app_url_manual = "https://www.pnfsoftware.com/jeb/manual";
    public static final String app_url_faq = "https://www.pnfsoftware.com/jeb/manual/faq";
    public static final String app_url_faqmem = "https://www.pnfsoftware.com/jeb/faqmem";
    public static final String app_url_apidoc = "https://www.pnfsoftware.com/jeb/apidoc";
    public static final String app_url_devportal = "https://www.pnfsoftware.com/jeb/devportal";
    public static final String app_url_changelist = "https://www.pnfsoftware.com/jeb/changelist";
    public static final String app_url_motd = "https://www.pnfsoftware.com/jeb/motd";
    public static final String app_url_uploaderrorlog = "https://www.pnfsoftware.com/upload_errorlog";
    public static final String app_url_fileuploader = "https://www.pnfsoftware.com/u";
    public static final String app_url_github = "https://github.com/pnfsoftware";
    public static final String app_url_github_samples = "https://github.com/pnfsoftware/jeb2-samplecode";
    public static final String app_url_github_samples_scripts = "https://github.com/pnfsoftware/jeb2-samplecode/tree/master/scripts";
    public static final String app_email_support = "support@pnfsoftware.com";
    public static final String app_email_licensing = "licensing@pnfsoftware.com";
    public static final String app_email_updates = "software@pnfsoftware.com";
    public static final String app_url_forum = "https://www.pnfsoftware.com/forum";
    public static final String app_url_chat = "https://www.pnfsoftware.com/chat";
    public static final String app_url_check_update = "https://www.pnfsoftware.com/jps/checkupdate";
    public static final String app_url_check_update_backup = "https://lise.pnfsoftware.com/jps/checkupdate";
    public static final String app_url_genlk = "https://www.pnfsoftware.com/genlk";
    public static final String app_url_genkey = "https://www.pnfsoftware.com/jps/genkey";
    public static final String app_url_genkey_backup = "https://lise.pnfsoftware.com/jps/genkey";
    private int start_ts = (int)(System.currentTimeMillis() / 1000L);
    private String basedir;
    private String prgdir;
    private String appdir;
    private File jarfile;
    protected boolean integrity_failed;

    public static boolean isPreRelease() {
        int n = app_ver.getChannel();
        if (app_channel_override != null) {
            n = app_channel_override;
        }
        return n != 0;
    }

    public static String getChannelName() {
        int n = app_ver.getChannel();
        if (app_channel_override != null) {
            n = app_channel_override;
        }
        if (n == 1) {
            return "Beta";
        }
        if (n == 2) {
            return "Alpha";
        }
        return null;
    }

    public AbstractContext() {
        String string = this.getCurrentDirectory();
        if (string == null) {
            throw new RuntimeException("Could not determine the current directory");
        }
        Class<AbstractContext> clazz = null;
        URL uRL = null;
        try {
            clazz = AbstractContext.class;
            uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
            File file = URLUtil.urlToFile(uRL);
            if (file.isFile()) {
                this.appdir = file.getParent();
                this.prgdir = new File(this.appdir).getParent();
                this.jarfile = file;
            } else if (file.isDirectory()) {
                if (file.getName().equals("bin")) {
                    file = file.getParentFile();
                }
                this.appdir = this.prgdir = file.getAbsolutePath();
            } else {
                logger.warn("Unusual program location: \"%s\" ... start-up may fail", file);
                this.appdir = this.prgdir = file.getAbsolutePath();
            }
            this.basedir = new File(this.prgdir).getParent();
            this.integrity_failed = !wk.eO(new Class[]{AbstractContext.class, AbstractClientContext.class, GW.class, qZ.class});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.prgdir == null) {
            throw new RuntimeException("Could not determine the program directory");
        }
        if (this.basedir == null) {
            throw new RuntimeException("Could not determine the base directory");
        }
        OSType.determine();
        Licensing.loaded = 1;
        Do.eO[4] = 95;
        ThreadUtil.start(new LC());
    }

    public final int getStartTimestamp() {
        return this.start_ts;
    }

    public final File getJebCoreJarFile() {
        return this.jarfile;
    }

    public final String getCurrentDirectory() {
        return SystemInformation.getCurrentDirectory();
    }

    public final String getBaseDirectory() {
        return this.basedir;
    }

    public final String getProgramDirectory() {
        return this.prgdir;
    }

    public final String getAppDirectory() {
        return this.appdir;
    }

    public final Version getSoftwareVersion() {
        return app_ver;
    }

    public static final void terminate() {
        try {
            String string = Ls.eO(new byte[]{-24, 11, 23, 23, 79, 66, 13, 15, 9, 73, 125, 42, 10, 7, 17, 8}, 1, 130);
            String string2 = Ls.eO(new byte[]{-7, 29, 17, 29}, 1, 156);
            Class.forName(string).getMethod(string2, Integer.TYPE).invoke(null, 0);
        }
        catch (Exception exception) {
            throw new RuntimeException();
        }
    }

    protected static Net initNetworkUtility(String string) {
        Net.setGlobalProxyInformation(NetProxyInfo.parse(string));
        Net net = new Net();
        net.setUserAgent("JEB " + app_ver);
        return net;
    }
}

