/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.modules;

import com.pnf.androsig.apply.matcher.ContextMatches;
import com.pnf.androsig.apply.matcher.DatabaseMatcherParameters;
import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.matcher.FileMatches;
import com.pnf.androsig.apply.matcher.HierarchyMatcher;
import com.pnf.androsig.apply.matcher.IAndrosigModule;
import com.pnf.androsig.apply.matcher.MatchingSearch;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.modules.AbstractModule;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPrototype;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodFinderModule
extends AbstractModule {
    private DatabaseMatcherParameters params;
    private List<IAndrosigModule> modules;

    public MethodFinderModule(ContextMatches contextMatches, FileMatches fileMatches, DatabaseReference ref, DatabaseMatcherParameters params, List<IAndrosigModule> modules) {
        super(contextMatches, fileMatches, ref);
        this.params = params;
        this.modules = modules;
    }

    @Override
    public void initNewPass(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
    }

    @Override
    public Map<Integer, String> postProcessRenameClasses(IDexUnit dex, DexHashcodeList dexHashCodeList, boolean firstRound) {
        for (Map.Entry<Integer, String> entry : this.fileMatches.entrySetMatchedClasses()) {
            Couple<String, List<String>> hierarchy;
            List methods;
            IDexClass eClass = dex.getClass(entry.getKey().intValue());
            if (eClass == null) continue;
            DatabaseReferenceFile refFile = this.fileMatches.getFileFromClass(dex, eClass);
            Set<Object> refFiles = null;
            if (refFile == null) {
                refFile = this.fileMatches.getMatchedClassFile(dex, eClass, entry.getValue(), this.ref);
            }
            if ((methods = eClass.getMethods()) == null || methods.size() == 0) continue;
            String className = entry.getValue();
            MatchingSearch search = new MatchingSearch(dex, dexHashCodeList, this.ref, this.params, this.fileMatches, this.modules, firstRound, false);
            List<MethodSignature> alreadyMatches = this.getAlreadyMatched(dex, className, methods, search, refFile);
            int matchedMethodsSize = alreadyMatches.size();
            block1: do {
                matchedMethodsSize = alreadyMatches.size();
                for (IDexMethod eMethod : methods) {
                    if (!eMethod.isInternal() || this.fileMatches.containsMatchedMethod(eMethod)) continue;
                    if (refFiles == null) {
                        if (refFile != null) {
                            refFiles = new HashSet<DatabaseReferenceFile>();
                            refFiles.add(refFile);
                        } else {
                            refFiles = this.fileMatches.getCandidateFilesFromClass(dex, eClass);
                        }
                        if (refFiles == null) continue block1;
                    }
                    List instructions = eMethod.getInstructions();
                    String methodHint = this.getHintMethodName(eMethod);
                    String methodNameMerged = "";
                    ArrayList<MethodSignature> strArrays = new ArrayList<MethodSignature>();
                    IDexPrototype proto = dex.getPrototype(eMethod.getPrototypeIndex());
                    String prototypes = proto.generate(true);
                    String shorty = proto.getShorty();
                    if (methodHint == null && instructions != null && instructions.size() > this.params.methodSizeBar) {
                        String mhash_tight = dexHashCodeList.getTightHashcode(eMethod);
                        if (mhash_tight == null) continue;
                        for (Object file : refFiles) {
                            MethodSignature strArray = search.findMethodMatch((DatabaseReferenceFile)file, mhash_tight, prototypes, shorty, className, (Collection<MethodSignature>)alreadyMatches, eMethod, false);
                            if (strArray != null) {
                                String newMethodName = strArray.getMname();
                                if (newMethodName.isEmpty()) {
                                    methodNameMerged = null;
                                    break;
                                }
                                if (methodNameMerged.isEmpty()) {
                                    methodNameMerged = newMethodName;
                                    strArrays.add(strArray);
                                    continue;
                                }
                                if (methodNameMerged.equals(newMethodName)) continue;
                                methodNameMerged = null;
                                break;
                            }
                            methodNameMerged = null;
                            break;
                        }
                    }
                    if (methodHint != null || Strings.isBlank((String)methodNameMerged) && !firstRound) {
                        Object file;
                        methodNameMerged = "";
                        HashMap<String, HashMap<DatabaseReferenceFile, MethodSignature>> strArraysMap = new HashMap<String, HashMap<DatabaseReferenceFile, MethodSignature>>();
                        ArrayList<DatabaseReferenceFile> toRemove = new ArrayList<DatabaseReferenceFile>();
                        file = refFiles.iterator();
                        while (file.hasNext()) {
                            MethodSignature strArray;
                            DatabaseReferenceFile file2 = (DatabaseReferenceFile)file.next();
                            List<MethodSignature> sigs = search.getSignaturesForClassname(file2, className, true, eMethod);
                            if (sigs.isEmpty()) continue;
                            if (methodHint != null) {
                                sigs = sigs.stream().filter(s -> methodHint.equals(s.getMname())).collect(Collectors.toList());
                            }
                            if ((strArray = search.findMethodName(sigs, prototypes, shorty, className, alreadyMatches, eMethod)) != null) {
                                HashMap<DatabaseReferenceFile, MethodSignature> map = (HashMap<DatabaseReferenceFile, MethodSignature>)strArraysMap.get(strArray.getMname());
                                if (map == null) {
                                    map = new HashMap<DatabaseReferenceFile, MethodSignature>();
                                    strArraysMap.put(strArray.getMname(), map);
                                }
                                map.put(file2, strArray);
                                continue;
                            }
                            toRemove.add(file2);
                        }
                        if (!toRemove.isEmpty() && toRemove.size() != refFiles.size()) {
                            file = toRemove.iterator();
                            while (file.hasNext()) {
                                DatabaseReferenceFile r = (DatabaseReferenceFile)file.next();
                                this.fileMatches.removeCandidateFile(r);
                            }
                        }
                        if (strArraysMap.size() == 1) {
                            Map map = (Map)strArraysMap.values().iterator().next();
                            strArrays = new ArrayList(map.values());
                            methodNameMerged = (String)strArraysMap.keySet().iterator().next();
                        }
                    }
                    if (Strings.isBlank((String)methodNameMerged)) continue;
                    MethodSignature strArray = null;
                    if (strArrays.size() == 1) {
                        strArray = (MethodSignature)strArrays.get(0);
                    } else {
                        strArray = MethodSignature.mergeSignatures(strArrays, false, eMethod);
                        if (strArray.getPrototype().isEmpty()) {
                            strArray = null;
                        }
                    }
                    if (strArray == null) {
                        this.saveMethodMatch(eMethod.getIndex(), methodNameMerged);
                        continue;
                    }
                    this.fileMatches.addMatchedMethod(dex, eMethod.getIndex(), strArray);
                    alreadyMatches.add(strArray);
                }
            } while (matchedMethodsSize != alreadyMatches.size());
            if (refFile == null || (hierarchy = this.ref.getParentForClassname(refFile, className)) == null) continue;
            HierarchyMatcher hierarchyMgr = new HierarchyMatcher(eClass);
            String supertype = (String)hierarchy.getFirst();
            List interfaces = (List)hierarchy.getSecond();
            if (supertype != null) {
                this.saveClassMatchInherit(hierarchyMgr.getSuperType(), supertype, className);
            }
            if (interfaces == null || interfaces.isEmpty()) continue;
            List<String> realInterfaces = hierarchyMgr.getInterfaces();
            block6: for (int i = 0; i < realInterfaces.size(); ++i) {
                String realSig = realInterfaces.get(i);
                for (int j = 0; j < interfaces.size(); ++j) {
                    String sig = (String)interfaces.get(j);
                    if (!realSig.equals(sig)) continue;
                    realInterfaces.remove(i);
                    --i;
                    interfaces.remove(j);
                    continue block6;
                }
            }
            if (realInterfaces.size() == 1 && interfaces.size() == 1) {
                this.saveClassMatchInherit(realInterfaces.get(0), (String)interfaces.get(0), className);
                continue;
            }
            if (realInterfaces.isEmpty() || interfaces.isEmpty()) continue;
            for (String interName : realInterfaces) {
                ArrayList<String> candidates = new ArrayList<String>();
                for (String c : interfaces) {
                    if (!DexUtilLocal.isCompatibleClasses(c, interName)) continue;
                    candidates.add(c);
                }
                if (candidates.size() != 1) continue;
                this.saveClassMatchInherit(interName, (String)candidates.get(0), className);
                interfaces.remove(candidates.get(0));
            }
        }
        return new HashMap<Integer, String>();
    }

    private String getHintMethodName(IDexMethod eMethod) {
        String methodHint = this.contextMatches.getMethod(eMethod.getIndex());
        if (methodHint == null) {
            return null;
        }
        return this.contextMatches.isValid(methodHint) ? methodHint : null;
    }

    @Override
    public Map<Integer, String> postProcessRenameMethods(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
        return new HashMap<Integer, String>();
    }

    @Override
    public Set<MethodSignature> filterList(IDexUnit dex, IDexMethod eMethod, List<MethodSignature> results) {
        return null;
    }

    private List<MethodSignature> getAlreadyMatched(IDexUnit dex, String className, List<? extends IDexMethod> methods, MatchingSearch search, DatabaseReferenceFile file) {
        ArrayList<MethodSignature> alreadyMatches = new ArrayList<MethodSignature>();
        for (IDexMethod iDexMethod : methods) {
            String methodName = this.fileMatches.getMatchedMethod(iDexMethod);
            if (methodName == null) continue;
            MethodSignature ms = this.fileMatches.getMatchedSigMethod(iDexMethod);
            if (ms == null) {
                if (file != null) {
                    ms = search.findMethodMatch(file, className, iDexMethod, methodName);
                }
                if (ms != null) {
                    this.fileMatches.bindMatchedSigMethod(dex, iDexMethod, ms);
                } else {
                    IDexPrototype proto = dex.getPrototype(iDexMethod.getPrototypeIndex());
                    String prototypes = proto.generate(true);
                    String shorty = proto.getShorty();
                    ms = new MethodSignature(className, methodName, shorty, prototypes, null);
                }
            }
            alreadyMatches.add(ms);
        }
        return alreadyMatches;
    }
}

