/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.apply.model.IStructureResult;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.MetadataGroup;
import com.pnfsoftware.jeb.core.units.MetadataGroupType;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Ser
public class DexMetadataGroupClass
extends MetadataGroup {
    @SerId(value=1)
    private Map<String, Object> cmap = new HashMap<String, Object>();
    @SerId(value=2)
    private final IStructureResult struRes;

    public DexMetadataGroupClass(String name, MetadataGroupType type, IStructureResult struRes) {
        super(name, type);
        this.struRes = struRes;
    }

    public Map<String, Object> getAllData() {
        return Collections.unmodifiableMap(this.cmap);
    }

    public Object getData(String address, AddressConversionPrecision precision) {
        if (address == null) {
            return null;
        }
        int pos = address.indexOf("->");
        if (pos < 0) {
            return null;
        }
        String classPath = address.substring(0, pos);
        String newClassPath = this.struRes.getMatchedClasses_new_orgPath().get(classPath);
        if (newClassPath == null) {
            return null;
        }
        return this.cmap.get(newClassPath);
    }

    public boolean setData(String classAddress, Object data) {
        if (!(data instanceof Integer)) {
            if (Licensing.isDebugBuild()) {
                throw new RuntimeException("Unexpected metadata value of type: " + (data == null ? null : data.getClass().getSimpleName()));
            }
            return false;
        }
        this.cmap.put(classAddress, data);
        return true;
    }
}

