/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.matcher;

import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContextMatches {
    private final ILogger logger = GlobalLog.getLogger(ContextMatches.class);
    private static final String INVALID_MATCH = "INVALID";
    private Map<String, CMatch> contextMatches = new HashMap<String, CMatch>();
    private Map<Integer, String> methodMatches = new HashMap<Integer, String>();

    public void saveParamMatching(String oldProto, String newProto, String className, Integer eMethodIndex, String methodName) {
        String[] tokens1 = oldProto.substring(1).split("\\)");
        if (newProto.isEmpty()) {
            return;
        }
        String[] tokens2 = newProto.substring(1).split("\\)");
        if (tokens1.length != 2 || tokens2.length != 2) {
            return;
        }
        List<String> oldClasses = DexUtilLocal.parseSignatureParameters(tokens1[0]);
        oldClasses.add(tokens1[1]);
        List<String> newClasses = DexUtilLocal.parseSignatureParameters(tokens2[0]);
        newClasses.add(tokens2[1]);
        if (oldClasses.size() != newClasses.size()) {
            return;
        }
        for (int i = 0; i < oldClasses.size(); ++i) {
            String oldClass = oldClasses.get(i);
            String newClass = newClasses.get(i);
            if (!oldClass.endsWith(";")) continue;
            while (oldClass.charAt(0) == '[') {
                if (newClass.charAt(0) != '[') {
                    return;
                }
                oldClass = oldClass.substring(1);
                newClass = newClass.substring(1);
            }
            this.saveClassMatch(oldClass, newClass, className, eMethodIndex, methodName);
        }
    }

    private void saveClassMatch(String oldClass, String newClass, Integer eMethodIndex, BoundType type, String ... params) {
        Boolean res = this.saveClassMatch(oldClass, newClass, eMethodIndex);
        if (res == Boolean.FALSE) {
            return;
        }
        if (res == Boolean.TRUE) {
            switch (type) {
                case InnerClass: {
                    this.logger.debug("Found match class: %s related to innerClass %s", new Object[]{newClass, params[0]});
                    break;
                }
                case Inherit: {
                    this.logger.debug("Found match class: %s related to inherited %s", new Object[]{newClass, params[0]});
                    break;
                }
                case ParamMatching: {
                    this.logger.debug("Found match class: %s by param matching from %s->%s", new Object[]{newClass, params[0], params[1]});
                    break;
                }
                case UnknownSourceFile: {
                    this.logger.debug("Found match class: %s from different files", new Object[]{newClass});
                    break;
                }
                default: {
                    this.logger.debug("Found match class: %s", new Object[]{newClass});
                }
            }
        }
        if (DexUtilLocal.isInnerClass(newClass)) {
            oldClass = DexUtilLocal.getParentSignature(oldClass);
            newClass = DexUtilLocal.getParentSignature(newClass);
            this.saveClassMatch(oldClass, newClass, eMethodIndex, type, params);
        }
    }

    public void saveClassMatch(String oldClass, String newClass, String innerClass) {
        this.saveClassMatch(oldClass, newClass, null, BoundType.InnerClass, innerClass);
    }

    public void saveClassMatchInherit(String oldClass, String newClass, String inherit) {
        this.saveClassMatch(oldClass, newClass, null, BoundType.Inherit, inherit);
    }

    public void saveClassMatch(String oldClass, String newClass, String className, Integer eMethodIndex, String methodName) {
        this.saveClassMatch(oldClass, newClass, eMethodIndex, BoundType.ParamMatching, className, methodName);
    }

    public void saveClassMatchUnkownFile(String oldClass, String newClass) {
        this.saveClassMatch(oldClass, newClass, null, BoundType.UnknownSourceFile, new String[0]);
    }

    public void setInvalidMethod(Integer key) {
        this.methodMatches.put(key, INVALID_MATCH);
    }

    private Match getMatch(CMatch value, String newName) {
        return this.getMatch(value.matches, newName);
    }

    private Match getMatch(List<Match> value, String newName) {
        for (Match val : value) {
            if (!val.newName.equals(newName)) continue;
            return val;
        }
        return null;
    }

    private Boolean saveClassMatch(String oldClass, String newClass, Integer methodIndex) {
        Match val;
        if (DexUtilLocal.getInnerClassLevel(oldClass) != DexUtilLocal.getInnerClassLevel(newClass)) {
            return Boolean.FALSE;
        }
        if (oldClass.charAt(0) != 'L' || newClass.charAt(0) != 'L') {
            return Boolean.FALSE;
        }
        CMatch value = this.contextMatches.get(oldClass);
        if (value == null) {
            value = new CMatch();
            this.contextMatches.put(oldClass, value);
        }
        if ((val = this.getMatch(value, newClass)) == null) {
            val = new Match(newClass);
            value.matches.add(val);
        }
        val.addMethod(methodIndex);
        if (value.processed && !newClass.equals(value.name)) {
            value.processed = false;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public boolean saveMethodMatch(Integer oldMethod, String newMethod) {
        String value = this.methodMatches.get(oldMethod);
        if (value != null) {
            if (value.equals(INVALID_MATCH)) {
                return false;
            }
            if (!value.equals(newMethod)) {
                this.methodMatches.put(oldMethod, INVALID_MATCH);
                return false;
            }
        }
        this.methodMatches.put(oldMethod, newMethod);
        return true;
    }

    public Set<String> keySet() {
        return new HashSet<String>(this.contextMatches.keySet());
    }

    public CMatch get(String key) {
        return this.contextMatches.get(key);
    }

    public String getMethod(Integer key) {
        return this.methodMatches.get(key);
    }

    public Set<Map.Entry<Integer, String>> methodsEntrySet() {
        return this.methodMatches.entrySet();
    }

    public boolean isValid(String value) {
        return !value.equals(INVALID_MATCH);
    }

    private static enum BoundType {
        InnerClass,
        Inherit,
        ParamMatching,
        UnknownSourceFile;

    }

    public static class Match {
        String newName;
        int count;
        List<Integer> methodIndexes = new ArrayList<Integer>();

        public Match(String newName) {
            this.newName = newName;
        }

        public void addMethod(Integer methodIndex) {
            ++this.count;
            if (methodIndex != null) {
                this.methodIndexes.add(methodIndex);
            }
        }
    }

    public static class CMatch {
        List<Match> matches = new ArrayList<Match>();
        boolean processed = false;
        String name = null;
    }
}

