/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.FunctionDef;
import com.pnf.libravm.Libra;
import com.pnf.libravm.LibraInstruction;
import com.pnf.libravm.LibraUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.SourceCustomizerAdapter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COutputSink;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICNativeStatement;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;

public class LibraSourceCustomizer
extends SourceCustomizerAdapter {
    LibraUnit libra;
    INativeCodeUnit<LibraInstruction> code;
    INativeDecompilerUnit<LibraInstruction> decomp;

    public LibraSourceCustomizer(INativeDecompilerUnit<LibraInstruction> decomp) {
        this.decomp = decomp;
        this.code = (INativeCodeUnit)decomp.getParent();
        this.libra = (LibraUnit)this.code.getParent();
    }

    public boolean generateClassDeclarationLine(ICClass elt, COutputSink out) {
        if (this.libra.getBinaryType() == Libra.BinaryType.MODULE) {
            out.appendKeyword("module");
            out.space();
            elt.getClasstype().generate(out);
            return true;
        }
        return false;
    }

    public boolean preFieldsGeneration(ICClass elt, COutputSink out) {
        return true;
    }

    public boolean preMethodsGeneration(ICClass elt, COutputSink out) {
        return true;
    }

    public boolean generateMethodDeclarationLine(ICMethod elt, COutputSink out) {
        int index = elt.getIndex();
        INativeMethodItem routine = this.code.getMethodByIndex(index);
        FunctionDef f = this.libra.getFunctionByAddress(routine.getData().getMemoryAddress());
        if (f.getFlags() != 0) {
            out.appendKeyword(Libra.formatFunctionFlags(f.getFlags()));
            out.space();
        }
        return false;
    }

    public boolean generateNativeStatement(ICNativeStatement elt, COutputSink out) {
        return super.generateNativeStatement(elt, out);
    }
}

