/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.libravm;

import com.pnf.libravm.Libra;
import com.pnf.libravm.LibraInstruction;
import com.pnf.libravm.LibraUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IGlobalAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilationTarget;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeClassItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IClassManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.IClassType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;

public class LibraModuleRebuilder
implements IGlobalAnalyzer {
    private static final ILogger logger = GlobalLog.getLogger(LibraModuleRebuilder.class);
    public static final String StandardModuleName = "DecompiledModule";
    LibraUnit libra;
    INativeCodeUnit<LibraInstruction> code;
    INativeDecompilerUnit<LibraInstruction> decomp;
    private INativeClassItem classItem;

    public LibraModuleRebuilder(INativeDecompilerUnit<LibraInstruction> decomp) {
        this.decomp = decomp;
        this.code = (INativeCodeUnit)decomp.getParent();
        this.libra = (LibraUnit)this.code.getParent();
    }

    public INativeClassItem getRebuiltModule() {
        return this.classItem;
    }

    public boolean perform() {
        if (this.libra.getBinaryType() == Libra.BinaryType.SCRIPT) {
            return true;
        }
        if (this.libra.getBinaryType() != Libra.BinaryType.MODULE) {
            return false;
        }
        if (this.classItem != null) {
            throw new IllegalStateException("The module was already rebuilt");
        }
        try (ACLock unused = this.code.getLock().a();){
            this.rebuildModule();
        }
        return true;
    }

    void rebuildModule() {
        ITypeManager typeman = this.code.getTypeManager();
        IClassManager classman = this.code.getClassManager();
        List routines = this.code.getInternalMethods();
        for (INativeMethodItem routine : routines) {
            this.decompile(routine, null);
        }
        String classname = StandardModuleName;
        IClassType classType = typeman.createClassType(classname, 1, 0);
        this.classItem = classman.createClassItem(classType);
        typeman.completeClassTypeInitialization(classType);
        for (INativeMethodItem routine : routines) {
            classman.addNonVirtualMethod(this.classItem, routine);
        }
        classman.completeClassItemInitialization(this.classItem);
        for (INativeMethodItem routine : routines) {
            classman.move((INativeItem)routine, this.classItem);
        }
    }

    INativeDecompilationTarget decompile(INativeMethodItem routine, NativeDecompilationStage stage) {
        try {
            return this.decomp.decompileMethod(routine, true, stage, null);
        }
        catch (Exception e) {
            logger.catchingSilent((Throwable)e);
            return null;
        }
    }

    INativeDecompilationTarget decompilePartial(INativeMethodItem routine) {
        return this.decompile(routine, NativeDecompilationStage.LIFTING_COMPLETED);
    }
}

