/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.printer;

import com.github.kwart.jd.JavaDecompilerConstants;
import com.github.kwart.jd.options.DecompilerOptions;
import org.jd.core.v1.api.printer.Printer;

public class StringBuilderPrinter
implements Printer {
    protected static final String INDENTATION = "  ";
    protected int indentationCount;
    protected StringBuilder sb = new StringBuilder();
    protected String format;
    private final DecompilerOptions options;

    public StringBuilderPrinter(DecompilerOptions options) {
        this.options = options;
    }

    public void init() {
        this.sb.setLength(0);
        this.indentationCount = 0;
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        this.indentationCount = 0;
        if (maxLineNumber == 0) {
            this.format = "%4d";
        } else {
            int width = 2;
            while (maxLineNumber >= 10) {
                ++width;
                maxLineNumber /= 10;
            }
            this.format = "%" + width + "d";
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void printText(String text) {
        if (this.options.isEscapeUnicodeCharacters()) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                if (c < '\u0080') {
                    this.sb.append(c);
                    continue;
                }
                int h = c >> 24;
                this.sb.append("\\u");
                this.sb.append(h <= 9 ? h + 48 : h + 65);
                h = c >> 16 & 0xFF;
                this.sb.append(h <= 9 ? h + 48 : h + 65);
                h = c >> 8 & 0xFF;
                this.sb.append(h <= 9 ? h + 48 : h + 65);
                h = c & 0xFF;
                this.sb.append(h <= 9 ? h + 48 : h + 65);
            }
        } else {
            this.sb.append(text);
        }
    }

    @Override
    public void printNumericConstant(String constant) {
        this.sb.append(constant);
    }

    @Override
    public void printStringConstant(String constant, String ownerInternalName) {
        this.printText(constant);
    }

    @Override
    public void printKeyword(String keyword) {
        this.sb.append(keyword);
    }

    @Override
    public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
        this.printText(name);
    }

    @Override
    public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
        this.printText(name);
    }

    @Override
    public void indent() {
        ++this.indentationCount;
    }

    @Override
    public void unindent() {
        if (this.indentationCount > 0) {
            --this.indentationCount;
        }
    }

    @Override
    public void startLine(int lineNumber) {
        this.printLineNumber(lineNumber);
        for (int i = 0; i < this.indentationCount; ++i) {
            this.sb.append(INDENTATION);
        }
    }

    @Override
    public void endLine() {
        this.sb.append(JavaDecompilerConstants.LS);
    }

    @Override
    public void extraLine(int count) {
        while (count-- > 0) {
            this.printLineNumber(0);
            this.sb.append(JavaDecompilerConstants.LS);
        }
    }

    @Override
    public void startMarker(int type) {
    }

    @Override
    public void endMarker(int type) {
    }

    protected void printLineNumber(int lineNumber) {
        if (this.options.isDisplayLineNumbers()) {
            this.sb.append("/* ");
            this.sb.append(String.format(this.format, lineNumber));
            this.sb.append(" */ ");
        }
    }
}

