/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.output;

import com.github.kwart.jd.output.AbstractJDOutput;
import java.io.InputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintStreamOutput
extends AbstractJDOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintStreamOutput.class);
    private final PrintStream ps;

    public PrintStreamOutput(PrintStream ps) {
        if (ps == null) {
            throw new NullPointerException("PrintStream can't be null.");
        }
        this.ps = ps;
    }

    @Override
    public void processClass(String className, String src) {
        LOGGER.debug("Processing class {}", (Object)className);
        this.ps.println(src);
    }

    @Override
    public void processResource(String fileName, InputStream is) {
        LOGGER.debug("Skipping resource {}", (Object)fileName);
    }
}

