/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.output;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.options.DecompilerOptions;
import com.github.kwart.jd.output.AbstractJDOutput;
import com.github.kwart.jd.output.JDOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOutput
extends AbstractJDOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiOutput.class);
    private final JDOutput[] outputPlugins;
    private final int validPlugins;

    public MultiOutput(JDOutput ... plugins) {
        LOGGER.trace("Creating MultiOutput");
        this.outputPlugins = plugins;
        int tmpValid = 0;
        if (this.outputPlugins != null && this.outputPlugins.length > 0) {
            for (JDOutput jdOut : this.outputPlugins) {
                if (jdOut != null) {
                    ++tmpValid;
                    continue;
                }
                LOGGER.warn("Null JDOutput provided to MultiOutput constructor.");
            }
        } else {
            LOGGER.warn("No JDOutput provided to MultiOutput constructor.");
        }
        LOGGER.trace("MultiOutput instance wraps {} valid plugin(s).", (Object)tmpValid);
        this.validPlugins = tmpValid;
    }

    public MultiOutput(Collection<JDOutput> plugins) {
        this(plugins.toArray(new JDOutput[plugins.size()]));
    }

    public boolean isValid() {
        return this.validPlugins > 0;
    }

    @Override
    public void init(DecompilerOptions options, String basePath) {
        if (!this.isValid()) {
            return;
        }
        for (JDOutput jdOut : this.outputPlugins) {
            if (jdOut == null) continue;
            try {
                jdOut.init(options, basePath);
            }
            catch (Exception e) {
                LOGGER.error("Callling init() of wrapped JDOutput failed.", e);
            }
        }
    }

    @Override
    public void processClass(String className, String src) {
        if (!this.isValid()) {
            return;
        }
        for (JDOutput jdOut : this.outputPlugins) {
            if (jdOut == null) continue;
            try {
                jdOut.processClass(className, src);
            }
            catch (Exception e) {
                LOGGER.error("Callling processClass() of wrapped JDOutput failed.", e);
            }
        }
    }

    @Override
    public void commit() {
        if (!this.isValid()) {
            return;
        }
        for (JDOutput jdOut : this.outputPlugins) {
            if (jdOut == null) continue;
            try {
                jdOut.commit();
            }
            catch (Exception e) {
                LOGGER.error("Callling commit() of wrapped JDOutput failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResource(String fileName, InputStream is) {
        switch (this.validPlugins) {
            case 0: {
                return;
            }
            case 1: {
                for (JDOutput jdOut : this.outputPlugins) {
                    if (jdOut == null) continue;
                    try {
                        jdOut.processResource(fileName, is);
                    }
                    catch (Exception e) {
                        LOGGER.error("Callling processResource() of wrapped JDOutput failed.", e);
                    }
                }
                break;
            }
            default: {
                File f = null;
                FileOutputStream fos = null;
                try {
                    try {
                        f = File.createTempFile("jdTemp-", ".res");
                        fos = new FileOutputStream(f);
                        IOUtils.copy(is, fos);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fos);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(fos);
                    for (JDOutput jdOut : this.outputPlugins) {
                        if (jdOut == null) continue;
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(f);
                            jdOut.processResource(fileName, fis);
                        }
                        catch (Exception e) {
                            try {
                                LOGGER.error("Callling processResource() of wrapped JDOutput failed.", e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fis);
                                throw throwable;
                            }
                            IOUtils.closeQuietly(fis);
                            continue;
                        }
                        IOUtils.closeQuietly(fis);
                    }
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Exception occured during handling processResource() for multiple wrapped JDOutput.", e);
                    break;
                }
                finally {
                    if (f != null) {
                        f.delete();
                    }
                }
            }
        }
    }
}

