/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.output;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.options.DecompilerOptions;
import com.github.kwart.jd.output.AbstractJDOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirOutput
extends AbstractJDOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirOutput.class);
    protected final File dir;
    private final AtomicLong countClasses = new AtomicLong();
    private final AtomicLong countResources = new AtomicLong();

    public DirOutput(File outputDir) {
        if (outputDir == null) {
            throw new NullPointerException("Null directory given");
        }
        this.dir = outputDir;
    }

    @Override
    public void init(DecompilerOptions options, String basePath) {
        super.init(options, basePath);
        this.countClasses.set(0L);
        this.countResources.set(0L);
        LOGGER.info("Directory output will be initialized for path {}", (Object)this.dir);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        if (!this.dir.isDirectory()) {
            LOGGER.error("Provided path is either not a directory or mkdirs() command failed: {}", (Object)this.dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processClass(String className, String src) {
        if (className == null || src == null) {
            LOGGER.warn("Class name or java source is null");
            return;
        }
        File decompiledFile = new File(this.getTargetDir(), className + ".java");
        LOGGER.trace("Writing decompiled class to {}", (Object)decompiledFile);
        this.createDir(decompiledFile.getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(decompiledFile);
            fos.write(src.getBytes(StandardCharsets.UTF_8));
            this.countClasses.addAndGet(1L);
        }
        catch (IOException e) {
            try {
                LOGGER.error("Writing decompiled class to file {} failed.", (Object)decompiledFile, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly(fos);
        }
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResource(String fileName, InputStream is) {
        if (this.options.isSkipResources() || fileName == null || is == null) {
            LOGGER.trace("Skipping resource {}", (Object)fileName);
            return;
        }
        File tmpFile = new File(this.getTargetDir(), fileName);
        LOGGER.trace("Storing resource {}", (Object)tmpFile);
        this.createDir(tmpFile.getParentFile());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tmpFile);
            IOUtils.copy(is, fos);
            this.countResources.addAndGet(1L);
        }
        catch (IOException e) {
            try {
                LOGGER.error("Writing resource to file {} failed.", (Object)tmpFile, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly(fos);
        }
        IOUtils.closeQuietly(fos);
    }

    @Override
    public void commit() {
        super.commit();
        LOGGER.info("Finished with {} class file(s) and {} resource file(s) written.", (Object)this.countClasses, (Object)this.countResources);
    }

    protected File getTargetDir() {
        return this.dir;
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            boolean dirCreated = dir.mkdirs();
            LOGGER.trace("Creating directory {} finished with result: {}", (Object)dir, (Object)dirCreated);
        }
    }
}

