/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.input;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.JavaDecompiler;
import com.github.kwart.jd.input.AbstractFileJDInput;
import com.github.kwart.jd.loader.CachedLoader;
import com.github.kwart.jd.options.DecompilerOptions;
import com.github.kwart.jd.output.JDOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jd.core.v1.api.loader.LoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileInput
extends AbstractFileJDInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFileInput.class);

    public ZipFileInput(String path) {
        super(path);
    }

    public ZipFileInput(String filePath, String pattern) throws IllegalArgumentException {
        super(filePath, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompile(JavaDecompiler javaDecompiler, JDOutput jdOutput) {
        if (javaDecompiler == null || jdOutput == null) {
            LOGGER.warn("Decompiler or JDOutput are null");
            return;
        }
        DecompilerOptions options = javaDecompiler.getOptions();
        boolean skipResources = options.isSkipResources();
        LOGGER.debug("Initializing decompilation of a zip file {}", (Object)this.file);
        jdOutput.init(options, this.file.getPath());
        ZipInputStream zis = null;
        CachedLoader cachedLoader = new CachedLoader();
        try {
            zis = new ZipInputStream(new FileInputStream(this.file));
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String entryName;
                if (entry.isDirectory() || this.skipThePath(entryName = entry.getName())) continue;
                if (IOUtils.isClassFile(entryName)) {
                    LOGGER.debug("Caching {}", (Object)entryName);
                    try {
                        cachedLoader.addClass(entryName, zis);
                    }
                    catch (LoaderException e) {
                        LOGGER.error("LoaderException occured", e);
                    }
                    continue;
                }
                if (!skipResources) {
                    LOGGER.debug("Processing resource file {}", (Object)entryName);
                    jdOutput.processResource(entryName, zis);
                    continue;
                }
                LOGGER.trace("Skipping resource file {}", (Object)entryName);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("IOException occured", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
            IOUtils.closeQuietly(zis);
        }
        IOUtils.closeQuietly(zis);
        Stream classNamesStream = options.isParallelProcessingAllowed() ? cachedLoader.getClassNames().parallelStream() : cachedLoader.getClassNames().stream();
        classNamesStream.filter(s -> !IOUtils.isInnerClass(s)).map(s -> IOUtils.cutClassSuffix(s)).forEach(name -> {
            try {
                jdOutput.processClass((String)name, javaDecompiler.decompileClass(cachedLoader, (String)name));
            }
            catch (Exception e) {
                LOGGER.error("Exception when decompiling class " + name, e);
            }
        });
        jdOutput.commit();
    }
}

