/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.input;

import com.github.kwart.jd.IOUtils;
import com.github.kwart.jd.JavaDecompiler;
import com.github.kwart.jd.input.AbstractFileJDInput;
import com.github.kwart.jd.loader.FileLoader;
import com.github.kwart.jd.output.JDOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirInput
extends AbstractFileJDInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirInput.class);
    private final FileLoader fileLoader;

    public DirInput(String path, String pattern) throws IllegalArgumentException {
        super(path, pattern);
        if (!this.file.isDirectory()) {
            throw new IllegalArgumentException("Path doesn't denote a directory.");
        }
        this.fileLoader = new FileLoader(path);
    }

    public DirInput(String path) {
        this(path, null);
    }

    @Override
    public void decompile(JavaDecompiler javaDecompiler, JDOutput jdOutput) {
        if (javaDecompiler == null || jdOutput == null) {
            LOGGER.warn("Decompiler or JDOutput are null");
            return;
        }
        LOGGER.debug("Initializing decompilation of directory {}", (Object)this.file);
        jdOutput.init(javaDecompiler.getOptions(), this.file.getPath());
        for (File f : this.file.listFiles()) {
            this.processFile(javaDecompiler, jdOutput, "", f);
        }
        jdOutput.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(JavaDecompiler javaDecompiler, JDOutput jdOutput, String pathPrefix, File nextFile) {
        String fileName = nextFile.getName();
        String nameWithPath = pathPrefix + fileName;
        if (nextFile.isDirectory()) {
            LOGGER.trace("Processing directory {}", (Object)nextFile);
            for (File f : nextFile.listFiles()) {
                this.processFile(javaDecompiler, jdOutput, pathPrefix + fileName + "/", f);
            }
        } else {
            if (this.skipThePath(nameWithPath)) {
                return;
            }
            if (IOUtils.isClassFile(fileName)) {
                if (IOUtils.isInnerClass(fileName)) {
                    LOGGER.trace("Skipping inner class {}", (Object)nextFile);
                    return;
                }
                LOGGER.debug("Decompiling {}", (Object)nextFile);
                String internalName = IOUtils.cutClassSuffix(nameWithPath);
                jdOutput.processClass(internalName, javaDecompiler.decompileClass(this.fileLoader, internalName));
            } else if (!javaDecompiler.getOptions().isSkipResources()) {
                LOGGER.debug("Processing resource file {}", (Object)nextFile);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(nextFile);
                    jdOutput.processResource(nameWithPath, fis);
                }
                catch (IOException ioe) {
                    try {
                        LOGGER.error("Resource processing failed for {}", (Object)nextFile, (Object)ioe);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(fis);
                }
                IOUtils.closeQuietly(fis);
            }
        }
    }
}

