/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jd.input;

import com.github.kwart.jd.input.JDInput;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileJDInput
implements JDInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileJDInput.class);
    protected final File file;
    private final String pattern;

    public AbstractFileJDInput(String filePath) throws IllegalArgumentException {
        this(filePath, null);
    }

    public AbstractFileJDInput(String filePath, String pattern) throws IllegalArgumentException {
        LOGGER.trace("Creating JDInput instance for file {} and pattern {}", (Object)filePath, (Object)pattern);
        this.pattern = pattern == null ? pattern : ".*" + pattern + ".*";
        this.file = new File(filePath);
        if (!this.file.exists()) {
            throw new IllegalArgumentException("Path doesn't denote an existing file.");
        }
    }

    protected boolean skipThePath(String path) {
        boolean skip;
        boolean bl = skip = this.pattern != null && path != null && !path.matches(this.pattern);
        if (skip) {
            LOGGER.debug("Skipping the path {} as it doesn't match the pattern {}", (Object)path, (Object)this.pattern);
        }
        return skip;
    }
}

