/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import specialAlgorithm.SpecialAlgorithm;

public class MD5Crypt
implements SpecialAlgorithm {
    private MessageDigest ctx;
    private MessageDigest ctx1;
    private MessageDigest ctx2;
    private static final String SALTCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final String itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String MAGIC = "$1$";
    private static byte[] MAGICBYTE = "$1$".getBytes();

    public MD5Crypt() {
        try {
            this.ctx = MessageDigest.getInstance("MD5");
            this.ctx1 = MessageDigest.getInstance("MD5");
            this.ctx2 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private final StringBuffer to64sb(long v, int size) {
        StringBuffer result = new StringBuffer();
        while (--size >= 0) {
            result.append(itoa64.charAt((int)(v & 0x3FL)));
            v >>>= 6;
        }
        return result;
    }

    private final void clearbits(byte[] bits) {
        int i = 0;
        while (i < bits.length) {
            bits[i] = 0;
            ++i;
        }
    }

    private final int bytes2u(byte inp) {
        return inp & 0xFF;
    }

    private final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String toHash(byte[] b) {
        return this.bytes2Utf8(b);
    }

    private String getRandomSalt() {
        StringBuffer salt = new StringBuffer();
        Random randgen = new Random();
        while (salt.length() < 8) {
            int index = (int)(randgen.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.substring(index, index + 1));
        }
        return salt.toString();
    }

    @Override
    public String crypt(String password, String salt) {
        if (salt == null) {
            salt = this.getRandomSalt();
        } else if (salt.length() > 8) {
            salt = salt.substring(0, 7);
        }
        return this.toHash(this.cryptPerf(password.getBytes(), salt.getBytes()));
    }

    @Override
    public byte[] cryptPerf(byte[] password, byte[] salt) {
        int passwordLength;
        if (salt.length > 8) {
            salt = MD5Crypt.truncateSalt(salt);
        }
        this.ctx.update(password);
        this.ctx.update(MAGICBYTE);
        this.ctx.update(salt);
        this.ctx1.update(password);
        this.ctx1.update(salt);
        this.ctx1.update(password);
        byte[] finalState = this.ctx1.digest();
        int pl = passwordLength = password.length;
        while (pl > 0) {
            int i = 0;
            while (i < (pl > 16 ? 16 : pl)) {
                this.ctx.update(finalState[i]);
                ++i;
            }
            pl -= 16;
        }
        this.clearbits(finalState);
        int i = passwordLength;
        while (i != 0) {
            if ((i & 1) != 0) {
                this.ctx.update(finalState[0]);
            } else {
                this.ctx.update(password[0]);
            }
            i >>>= 1;
        }
        finalState = this.ctx.digest();
        i = 0;
        while (i < 1000) {
            int c;
            if ((i & 1) != 0) {
                this.ctx2.update(password);
            } else {
                c = 0;
                while (c < 16) {
                    this.ctx2.update(finalState[c]);
                    ++c;
                }
            }
            if (i % 3 != 0) {
                this.ctx2.update(salt);
            }
            if (i % 7 != 0) {
                this.ctx2.update(password);
            }
            if ((i & 1) != 0) {
                c = 0;
                while (c < 16) {
                    this.ctx2.update(finalState[c]);
                    ++c;
                }
            } else {
                this.ctx2.update(password);
            }
            finalState = this.ctx2.digest();
            ++i;
        }
        StringBuilder result = new StringBuilder();
        result.append(MAGIC);
        result.append(this.bytes2Utf8(salt));
        result.append('$');
        long l = this.bytes2u(finalState[0]) << 16 | this.bytes2u(finalState[6]) << 8 | this.bytes2u(finalState[12]);
        result.append(this.to64sb(l, 4));
        l = this.bytes2u(finalState[1]) << 16 | this.bytes2u(finalState[7]) << 8 | this.bytes2u(finalState[13]);
        result.append(this.to64sb(l, 4));
        l = this.bytes2u(finalState[2]) << 16 | this.bytes2u(finalState[8]) << 8 | this.bytes2u(finalState[14]);
        result.append(this.to64sb(l, 4));
        l = this.bytes2u(finalState[3]) << 16 | this.bytes2u(finalState[9]) << 8 | this.bytes2u(finalState[15]);
        result.append(this.to64sb(l, 4));
        l = this.bytes2u(finalState[4]) << 16 | this.bytes2u(finalState[10]) << 8 | this.bytes2u(finalState[5]);
        result.append(this.to64sb(l, 4));
        l = this.bytes2u(finalState[11]);
        result.append(this.to64sb(l, 2));
        this.clearbits(finalState);
        return ByteArray.toByteArray(result);
    }

    private static byte[] truncateSalt(byte[] salt) {
        int maxSaltLength = 8;
        byte[] returnValue = new byte[maxSaltLength];
        int i = 0;
        while (i < maxSaltLength) {
            returnValue[i] = salt[i];
            ++i;
        }
        return returnValue;
    }

    @Override
    public byte[] toByteArray(String hash) {
        return hash.getBytes();
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        byte[] salt = new byte[8];
        int auxIndex = 0;
        int i = 3;
        while (i < 11) {
            salt[auxIndex] = hash[i];
            ++auxIndex;
            ++i;
        }
        return salt;
    }

    @Override
    public final byte[] appendSaltToWord(byte[] word, byte[] salt) {
        byte[] saltedWord = new byte[word.length + 1 + salt.length];
        int i = 0;
        while (i < word.length) {
            saltedWord[i] = word[i];
            ++i;
        }
        saltedWord[word.length] = 36;
        return ByteArray.concat(saltedWord, salt);
    }
}

