/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop;

import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.SingleFrameApplication;
import com.aspect.snoop.StartupView;
import java.awt.Window;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class JavaSnoop
extends SingleFrameApplication {
    public static final String VERSION = "version";
    public static final String SEPARATE_VM = "exec_separate_vm";
    public static final String LAST_SELECTED_DIR = "last_classpath_dir";
    public static final String USE_JAD = "use_jad";
    public static final String JAD_PATH = "jad_path";
    public static final String LOAD_WAIT = "load_wait";
    public static final String LAST_DUMPED_DIR = "last_dumped_dir";
    private static Properties props = new Properties();
    private static String propFile = System.getProperty("user.home") + File.separator + "JavaSnoop.properties";
    private StartupView mainForm;

    @Override
    protected void startup() {
        this.mainForm = new StartupView(this);
        this.show(this.mainForm);
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static JavaSnoop getApplication() {
        return Application.getInstance(JavaSnoop.class);
    }

    public static void main(String[] args) {
        JavaSnoop.launch(JavaSnoop.class, args);
    }

    public static Properties getProperties() {
        return props;
    }

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static int getIntProperty(String key) {
        try {
            return Integer.parseInt(props.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static boolean getBooleanProperty(String key, boolean def) {
        String val = props.getProperty(key);
        return val != null ? val.equalsIgnoreCase("true") : def;
    }

    public static void saveProperties() {
        try {
            props.store(new FileWriter(new File(propFile)), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initializePropertiesFile(String propFile) throws IOException {
        JavaSnoop.getDefaultProperties().store(new FileWriter(new File(propFile)), null);
    }

    private static Properties getDefaultProperties() {
        Properties p = new Properties();
        p.setProperty(VERSION, "1.0");
        p.setProperty(SEPARATE_VM, "true");
        p.setProperty(LOAD_WAIT, "3000");
        p.setProperty(USE_JAD, "false");
        p.setProperty(LAST_SELECTED_DIR, new File(System.getProperty("user.home")).getAbsolutePath());
        return p;
    }

    public static void setProperty(String key, String val) {
        props.put(key, val);
    }

    static {
        try {
            if (!new File(propFile).exists()) {
                JavaSnoop.initializePropertiesFile(propFile);
            }
            props.load(new FileReader(propFile));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

