/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.List;
import soot.Body;
import soot.Local;
import soot.Value;
import soot.ValueBox;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum LocalsValidator implements BodyValidator
{
    INSTANCE;


    public static LocalsValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        for (ValueBox vb : body.getUseBoxes()) {
            this.validateLocal(body, vb, exception);
        }
        for (ValueBox vb : body.getDefBoxes()) {
            this.validateLocal(body, vb, exception);
        }
    }

    private void validateLocal(Body body, ValueBox vb, List<ValidationException> exception) {
        Value value2 = vb.getValue();
        if (value2 instanceof Local && !body.getLocals().contains(value2)) {
            exception.add(new ValidationException(value2, "Local not in chain : " + value2 + " in " + body.getMethod()));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

