/*
 * Decompiled with CFR 0.152.
 */
package soot.util.cfgcmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import soot.G;
import soot.Singletons;

public class AltClassLoader
extends ClassLoader {
    private static final boolean DEBUG = false;
    private String[] locations;
    private final Map<String, Class<?>> alreadyFound = new HashMap();
    private final Map<String, String> nameToMangledName = new HashMap<String, String>();
    private final Map<String, String> mangledNameToName = new HashMap<String, String>();

    public AltClassLoader(Singletons.Global g) {
    }

    public static AltClassLoader v() {
        return G.v().soot_util_cfgcmd_AltClassLoader();
    }

    public void setAltClassPath(String altClassPath) {
        LinkedList<String> locationList = new LinkedList<String>();
        StringTokenizer tokens = new StringTokenizer(altClassPath, File.pathSeparator, false);
        while (tokens.hasMoreTokens()) {
            String location = tokens.nextToken();
            locationList.add(location);
        }
        this.locations = new String[locationList.size()];
        this.locations = locationList.toArray(this.locations);
    }

    public void setAltClasses(String[] classNames) {
        this.nameToMangledName.clear();
        for (String origName : classNames) {
            String mangledName = AltClassLoader.mangleName(origName);
            this.nameToMangledName.put(origName, mangledName);
            this.mangledNameToName.put(mangledName, origName);
        }
    }

    private static String mangleName(String origName) throws IllegalArgumentException {
        int lastDot;
        int dot = 46;
        int dotReplacement = 95;
        StringBuffer mangledName = new StringBuffer(origName);
        int replacements = 0;
        int nextDot = lastDot = origName.lastIndexOf(46);
        while ((nextDot = origName.lastIndexOf(46, nextDot - 1)) >= 0) {
            mangledName.setCharAt(nextDot, '_');
            ++replacements;
        }
        if (replacements <= 0) {
            throw new IllegalArgumentException("AltClassLoader.mangleName()'s crude classname mangling cannot deal with " + origName);
        }
        return mangledName.toString();
    }

    @Override
    protected Class<?> findClass(String maybeMangledName) throws ClassNotFoundException {
        Class<?> result2 = this.alreadyFound.get(maybeMangledName);
        if (result2 != null) {
            return result2;
        }
        String name = this.mangledNameToName.get(maybeMangledName);
        if (name == null) {
            name = maybeMangledName;
        }
        String pathTail = "/" + name.replace('.', File.separatorChar) + ".class";
        for (String element2 : this.locations) {
            String path = element2 + pathTail;
            try {
                FileInputStream stream = new FileInputStream(path);
                byte[] classBytes = new byte[stream.available()];
                stream.read(classBytes);
                this.replaceAltClassNames(classBytes);
                result2 = this.defineClass(maybeMangledName, classBytes, 0, classBytes.length);
                this.alreadyFound.put(maybeMangledName, result2);
                stream.close();
                return result2;
            }
            catch (IOException e) {
            }
            catch (ClassFormatError e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Unable to find class" + name + " in alternate classpath");
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        String nameForParent = this.nameToMangledName.get(name);
        if (nameForParent == null) {
            nameForParent = name;
        }
        return super.loadClass(nameForParent, false);
    }

    private void replaceAltClassNames(byte[] classBytes) {
        for (Map.Entry<String, String> entry2 : this.nameToMangledName.entrySet()) {
            String origName = entry2.getKey();
            origName = origName.replace('.', '/');
            String mangledName = entry2.getValue();
            mangledName = mangledName.replace('.', '/');
            AltClassLoader.findAndReplace(classBytes, AltClassLoader.stringToUtf8Pattern(origName), AltClassLoader.stringToUtf8Pattern(mangledName));
            AltClassLoader.findAndReplace(classBytes, AltClassLoader.stringToTypeStringPattern(origName), AltClassLoader.stringToTypeStringPattern(mangledName));
        }
    }

    private static byte[] stringToUtf8Pattern(String s2) {
        byte[] origBytes = s2.getBytes();
        int length2 = origBytes.length;
        boolean CONSTANT_Utf8 = true;
        byte[] result2 = new byte[length2 + 3];
        result2[0] = 1;
        result2[1] = (byte)(length2 & 0xFF00);
        result2[2] = (byte)(length2 & 0xFF);
        for (int i = 0; i < length2; ++i) {
            result2[i + 3] = origBytes[i];
        }
        return result2;
    }

    private static byte[] stringToTypeStringPattern(String s2) {
        byte[] origBytes = s2.getBytes();
        int length2 = origBytes.length;
        byte[] result2 = new byte[length2 + 2];
        result2[0] = 76;
        for (int i = 0; i < length2; ++i) {
            result2[i + 1] = origBytes[i];
        }
        result2[length2 + 1] = 59;
        return result2;
    }

    private static void findAndReplace(byte[] text, byte[] pattern, byte[] replacement) throws IllegalArgumentException {
        int patternLength = pattern.length;
        if (patternLength != replacement.length) {
            throw new IllegalArgumentException("findAndReplace(): The lengths of the pattern and replacement must match.");
        }
        int match = 0;
        while ((match = AltClassLoader.findMatch(text, pattern, match)) >= 0) {
            AltClassLoader.replace(text, replacement, match);
            match += patternLength;
        }
    }

    private static int findMatch(byte[] text, byte[] pattern, int start) {
        int textLength = text.length;
        int patternLength = pattern.length;
        block0: for (int base = start; base < textLength; ++base) {
            int t = base;
            for (int p = 0; p < patternLength; ++p) {
                if (text[t] != pattern[p]) continue block0;
                ++t;
            }
            return base;
        }
        return -1;
    }

    private static void replace(byte[] text, byte[] replacement, int start) {
        int t = start;
        for (int p = 0; p < replacement.length; ++p) {
            text[t] = replacement[p];
            ++t;
        }
    }

    public static void main(String[] argv) throws ClassNotFoundException {
        AltClassLoader.v().setAltClassPath(argv[0]);
        for (int i = 1; i < argv.length; ++i) {
            AltClassLoader.v().setAltClasses(new String[]{argv[i]});
            G.v().out.println("main() loadClass(" + argv[i] + ")");
            AltClassLoader.v().loadClass(argv[i]);
        }
    }
}

