/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.util.MultiMap;

public class HashMultiMap<K, V>
implements MultiMap<K, V> {
    Map<K, Set<V>> m = new HashMap<K, Set<V>>(0);

    public HashMultiMap() {
    }

    public HashMultiMap(MultiMap<K, V> m) {
        this.putAll(m);
    }

    public HashMultiMap(Map<K, Set<V>> m) {
        this.putAll(m);
    }

    @Override
    public void putAll(MultiMap<K, V> m) {
        for (K key2 : m.keySet()) {
            this.putAll(key2, m.get(key2));
        }
    }

    @Override
    public void putAll(Map<K, Set<V>> m) {
        for (K key2 : m.keySet()) {
            this.putAll(key2, m.get(key2));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.numKeys() == 0;
    }

    @Override
    public int numKeys() {
        return this.m.size();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.m.containsKey(key2);
    }

    @Override
    public boolean containsValue(V value2) {
        for (Set<V> s2 : this.m.values()) {
            if (!s2.contains(value2)) continue;
            return true;
        }
        return false;
    }

    protected Set<V> newSet() {
        return new HashSet(4);
    }

    private Set<V> findSet(K key2) {
        Set<V> s2 = this.m.get(key2);
        if (s2 == null) {
            s2 = this.newSet();
            this.m.put(key2, s2);
        }
        return s2;
    }

    @Override
    public boolean put(K key2, V value2) {
        return this.findSet(key2).add(value2);
    }

    @Override
    public boolean putAll(K key2, Set<V> values2) {
        if (values2.isEmpty()) {
            return false;
        }
        return this.findSet(key2).addAll(values2);
    }

    @Override
    public boolean remove(K key2, V value2) {
        Set<V> s2 = this.m.get(key2);
        if (s2 == null) {
            return false;
        }
        boolean ret = s2.remove(value2);
        if (s2.isEmpty()) {
            this.m.remove(key2);
        }
        return ret;
    }

    @Override
    public boolean remove(K key2) {
        return null != this.m.remove(key2);
    }

    @Override
    public boolean removeAll(K key2, Set<V> values2) {
        Set<V> s2 = this.m.get(key2);
        if (s2 == null) {
            return false;
        }
        boolean ret = s2.removeAll(values2);
        if (s2.isEmpty()) {
            this.m.remove(key2);
        }
        return ret;
    }

    @Override
    public Set<V> get(K o) {
        Set<V> ret = this.m.get(o);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<K> keySet() {
        return this.m.keySet();
    }

    @Override
    public Set<V> values() {
        HashSet<V> ret = new HashSet<V>(this.m.size());
        for (Set<V> s2 : this.m.values()) {
            ret.addAll(s2);
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm = (MultiMap)o;
        if (!this.keySet().equals(mm.keySet())) {
            return false;
        }
        for (Map.Entry<K, Set<V>> e : this.m.entrySet()) {
            Set<V> s2 = e.getValue();
            if (s2.equals(mm.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.m.hashCode();
    }

    @Override
    public int size() {
        return this.m.size();
    }
}

